var keyLamb = keyboard_check_pressed(vk_space);

var keyLeft = -keyboard_check(ord("A"));
var keyRight = keyboard_check(ord("D"));

var xdir = keyLeft+keyRight;

image_xscale = (xdir == 0 ? image_xscale : xdir);

if (keyLamb)
{
	if (!hasLamb && place_meeting(x,y,objLamb))
	{
		objLamb.pickedUp = true;
		objLamb.pick = false;
		objLamb.image_index = 0;
		image_index = 1;
		hasLamb = true;
	}
	else if (hasLamb)
	{
		objLamb.pickedUp = false;
		objLamb.image_yscale = 1;
		objLamb.moveX = 4*image_xscale;
		objLamb.y -= 2;
		objLamb.alarm[0] = random_range(5,30)*room_speed;
		image_index = 0;
		hasLamb = false;
		
		if (place_meeting(x,y,objAltar))
		{
			instance_destroy(objLamb);
		}
	}
}

var xspd = xdir * (hasLamb ? 0.8 : 1);

if !(bbox_left + xspd < 0 || bbox_right + xspd > room_width
		|| tilemap_get_at_pixel(map_id,xspd + (xspd < 0 ? bbox_left : bbox_right),y)
		|| place_meeting(x+xspd,y,objDoor))
{
	x += xspd;
}

if (!onGround)
{
	if (!tilemap_get_at_pixel(map_id,x,y+2) || place_meeting(x,bbox_bottom+2,objDoor))
	{
		y += 2;
	}
	else
	{
		y += 1;
	}
}

checkTeleport();