#define event_hunting
///event_hunting()

event_parent();
prompt = "There are a lot of animals around. You get the idea that you could hunt right now.";
//1. go hunting (1 tool)
//2. ignore the animals

if (global.supplies[SUPPLIES.TOOLS] >= 1)
    {
    option[0] = "It's hunting time!";
    event[0] = event_hunting_go;
    
    option[1] = "Ignore the animals and keep going.";
    event[1] = event_hunting_ignore;
    }
else
    {
    option[0] = "You don't have the tools to hunt.";
    event[0] = event_hunting_ignore;  
    }



#define event_hunting_ignore
///event_hunting_ignore()

event_parent();

prompt = "You set off, hoping you won't be needing cloth or food anytime soon.";

//move on
background_hspeed[1] = -1;

#define event_hunting_go
///event_hunting_go()

event_parent();

//use the tools
global.supplies[SUPPLIES.TOOLS] -= 1;

var roll;
roll = irandom(100)+(get_fantastic_count()*4)+(get_total_wellness()*2);
requirement = 85;

var c, f;
c = 0; f = 0;
if (roll > requirement-10)
    {
    //very bountiful!
    c = floor(global.day/6)+choose(4,5,6,7);
    f = floor(global.day/6)+choose(3,4,5,6);
    prompt = "The hunt was a huge success! You gathered "+string(c)+" cloth and "+string(f)+" food.";
    
    //keep going
    background_hspeed[1] = -1;
    }
else if (roll > requirement-25)
    {
    //success!
    c = floor(global.day/6)+choose(3,4,5);
    f = floor(global.day/6)+choose(2,3,4);
    prompt = "The hunt went well, but it could have been better. You gathered "+string(c)+" cloth and "+string(f)+" food.";
    
    //keep going
    background_hspeed[1] = -1;
    }
else if (roll > requirement-50)
    {
    prompt = "You were unable to kill anything so far. At least you didn't get hurt, though. Will you keep hunting?";
    
    option[0] = "Yes, keep hunting.";
    event[0] = event_hunting_yes;
    
    option[1] = "No, it could be a waste of time.";
    event[1] = event_hunting_no;
    }
else
    {
    //awful failure
    prompt = "Not only could you not kill anything, you wasted so much time, and you're starting to feel a bit sick.";
    //lower wellness for whole family
    lower_family_wellness();
    
    //keep going
    background_hspeed[1] = -1;
    }

//Add cloth and food
global.supplies[SUPPLIES.CLOTH] += c;
global.supplies[SUPPLIES.FOOD] += f;



#define event_hunting_yes
///event_hunting_yes

event_parent();

if (irandom(100) < 50)
    {
    //minor success!
    var c, f;
    c = floor(global.day/6)+choose(2,3,3,4);
    f = floor(global.day/6)+choose(1,2,2,3);
    
    prompt = "It took a while but you finally caught something! You gathered "+string(c)+" cloth and "+string(f)+" food.";
    
    global.supplies[SUPPLIES.CLOTH] += c;
    global.supplies[SUPPLIES.FOOD] += f;
    }
else
    {
    //no success!
    prompt = "Despite your best efforts, you still couldn't catch anything.";
    }
    
global.event_score += 10;
    
//keep going
background_hspeed[1] = -1;

#define event_hunting_no
///event_hunting_no()

event_parent();

prompt = "You return to the wagon. Hopefully next time, you won't have such rotten luck.";

//move on
background_hspeed[1] = -1;