#define event_beggar
///event_beggar()

event_parent();
//when you approach a beggar...
// 1. give them what they ask
// 2. offer to let them join you
// 3. ignore them and move on

prompt = choose(
"You approach the beggar. 'Please sir, my name is "+obj_beggar.name+" and I really need some help. All I ask is just "+string(obj_beggar.demanded_amount)+" "+string_lower(global.supply_names[obj_beggar.demanded])+".'",
"You reach the beggar. 'I need help, please! I'm "+obj_beggar.name+" and all I want is "+string(obj_beggar.demanded_amount)+" "+string_lower(global.supply_names[obj_beggar.demanded])+".'",
"The beggar approachs the wagon. 'Please, please help me... I only need "+string(obj_beggar.demanded_amount)+" "+string_lower(global.supply_names[obj_beggar.demanded])+". Please help...'",
"The beggar talks to you. 'Hi... could you please spare "+string(obj_beggar.demanded_amount)+" "+string_lower(global.supply_names[obj_beggar.demanded])+"? I'm dying and need some help, please.'"
);

if (global.supplies[obj_beggar.demanded] >= obj_beggar.demanded_amount)
    {
    option[0] = "Kindly donate the supplies.";
    event[0] = event_beggar_donate;
    }
else
    {
    option[0] = "You don't have those supplies.";
    event[0] = -1;
    }
    
if (get_family_count() < 5)
    {
    option[1] = "Offer to let the beggar join you.";
    event[1] = event_beggar_offer;
    }
else
    {
    option[1] = "You already have 5 family members.";
    event[1] = -1;
    }

option[2] = "Apologize, and move on.";
event[2] = event_beggar_apologize;


#define event_beggar_donate
///event_beggar_donate()

event_parent();

prompt = "You gave the poor beggar what you could, and wished "+obj_beggar.pronoun+" good luck as you set off again.";
global.supplies[obj_beggar.demanded] -= obj_beggar.demanded_amount;

set_everybody_fantastic(true);

global.event_score += 100;

background_hspeed[1] = -1;

#define event_beggar_offer
///event_beggar_offer()

event_parent();
//depends on chance...
//1. they join you and become a new family member
//2. they come aboard, but run off with some supplies!
//3. they attack you! a family member may die, or if they're feeling fantastic, might be injured.
//4. they decline your offer and stay on the road

if (irandom(100) < 35+(10*get_fantastic_count())+(4*get_total_wellness())) || ((global.day <= 2) && (irandom(100) < 80))
    {
    //they join you!
    var f;
    for (f = 0; f <= 4; f++)
        {
        if (global.family[f,0] == FAMILY.NONE)
            {
            //set new member
            global.family[f,0] = obj_beggar.type;
            global.family[f,1] = obj_beggar.name;
            global.family[f,2] = choose(1,1,2,2,3);
            break;
            }
        }
    
    prompt = "Eternally grateful, your new family member "+obj_beggar.name+" hops into the wagon!";
        
    global.event_score += 50;
    
    obj_beggar.visible = false;
    background_hspeed[1] = -1;
    }
else if (irandom(100) < 40)
    {
    //they decline your offer
    
    prompt = "For some reason, the beggar declined the offer. You had to get going, leaving the beggar behind.";
    
    background_hspeed[1] = -1;
    }
else if (irandom(100) < 40) && (get_supply_total() > 0)
    {
    //they steal supplies
    var target;
    target = choose(0,1,2,3,3,4,4);
    while (global.supplies[target] <= 0)
        {
        target = choose(0,1,2,3,3,4,4);
        }
        
    stolen_amount = choose(1,2,3,4,4,5,5);
    if (stolen_amount > global.supplies[target]) //can't steal more than there is...
        {
        stolen_amount = global.supplies[target];
        }
        
    prompt = "The beggar climbs aboard... only to run off after stealing "+string(stolen_amount)+" "+string_lower(global.supply_names[target])+"! You continue on the trail.";
    
    global.supplies[target] -= stolen_amount;
    background_hspeed[1] = -1;
    }
else
    {
    //they attack you!
    var target;
    target = choose(0,1,2,3,4);
    while (global.family[target,0] == FAMILY.NONE)
        {
        target = choose(0,1,2,3,4);
        }
    
    if (irandom(100) < 30+(40*feeling_fantastic[target]))
        {
        //they escape, with a little less wellness
        prompt = "With no warning, the beggar lashes out and attacks! You were lucky enough to escape, even though "+global.family[target,1]+" sustained some serious injuries.";
        
        if (global.family[target,2] > 2)
            {
            global.family[target,2] = choose(1,1,2,2,2); //taken down to 1 or 2 wellness
            }
        else
            {
            global.family[target,2] = 1; //1 wellness left
            }
        }
    else
        {
        //They are killed.
        prompt = "Despite your kindness, the beggar attacked your wagon and manage to kill "+global.family[target,1]+"! You are forced to flee, or risk losing more family members.";
        play_sound(snd_death);
        global.dead_people += ", "+string(global.family[target,1]);
        
        //kill off
        global.family[target,0] = FAMILY.NONE;
        global.family[target,1] = "Nobody";
        global.family[target,2] = 0;
        
        //CHECK IF GAME OVER
        check_gameover();
        }
    
    //continue on
    background_hspeed[1] = -1;
    }

#define event_beggar_apologize
///event_beggar_apologize

event_parent();
prompt = "You regret not being able to help the poor beggar.";

set_everybody_fantastic(false);
global.event_score -= 50;

background_hspeed[1] = -1;
