#define event_chopping
///event_chopping()

event_parent();

prompt = "There are enough trees nearby, it wouldn't be hard to chop some up for wood.";

if (global.supplies[SUPPLIES.TOOLS] >= 1)
    {
    option[0] = "Grab a tool and get at it!";
    event[0] = event_chopping_go;
    
    option[1] = "Ignore the trees and move on.";
    event[1] = event_chopping_ignore;
    }
else
    {
    option[0] = "You don't have the tools.";
    event[0] = event_chopping_ignore;
    }



#define event_chopping_go
///event_chopping_go

event_parent();

//subtract those tools
global.supplies[SUPPLIES.TOOLS] -= 1;

prompt = "You survey your options in the forest. What will you cut?";
//1 cut down as many trees as you can
//2 cut some live and some dead trees
//3 cut down only dead trees

option[0] = "Chop all the trees you can.";
event[0] = event_chopping_all;

option[1] = "Chop just some of the trees around.";
event[1] = event_chopping_some;

option[2] = "Only chop down only the dead trees.";
event[2] = event_chopping_dead;


#define event_chopping_ignore
///event_chopping_ignore()

event_parent();

prompt = "It isn't worth the time. Chopping down trees can be very exhausting, too.";

//keep going
background_hspeed[1] = -1;

#define event_chopping_all
///event_chopping_all()

event_parent();

play_sound(snd_chopping);

var w;
w = floor(global.day/3)+choose(3,4,4,5,5,6,6,7);

prompt = "You obtained "+string(w)+" wood from chopping bits of almost every tree. Everybody is exhausted and nauseous from the trip, however.";

global.supplies[SUPPLIES.WOOD] += w;
lower_family_wellness();


//move on
background_hspeed[1] = -1;

#define event_chopping_some
///event_chopping_some

event_parent();

play_sound(snd_chopping);

var w;
w = floor(global.day/3)+choose(2,3,3,4);

prompt = "You managed to gather "+string(w)+" wood from the forest, hopefully without damaging it too much.";

global.event_score += 30;

global.supplies[SUPPLIES.WOOD] += w;

//move on
background_hspeed[1] = -1;

#define event_chopping_dead
///event_chopping_dead()

event_parent();

play_sound(snd_chopping);

var w;
w = floor(global.day/2)+choose(1,2,2);

if (irandom(100) < 50)
    {
    prompt = "You managed to gather "+string(w)+" wood from the dead trees."
    }
else if (irandom(100) < 50)
    {
    var f;
    f = choose(1,1,2,3);
    prompt = "You managed to gather "+string(w)+" wood, and also found "+string(f)+" food!";
    
    global.supplies[SUPPLIES.FOOD] += f;
    }
else
    {
    var t;
    t = choose(1,1,2,3);
    prompt = "You managed to gather "+string(w)+" wood, and also found "+string(t)+" tools left behind!";
    
    global.supplies[SUPPLIES.TOOLS] += t;
    }

global.supplies[SUPPLIES.WOOD] += w;
    
//move on
background_hspeed[1] = -1;
