#define event_pool
///event_pool()

event_parent();

prompt = "You spot a lake of water off the road a ways. Do you want to investigate it?";
//1. Yes, let's go take a look.
//2. No, it probably isn't safe.

option[0] = "Yes, let's go take a look.";
event[0] = event_pool_yes;

option[1] = "No, it's probably not safe.";
event[1] = event_pool_no;

#define event_pool_yes
///event_pool_yes

event_parent();

prompt = "You approach the pool. ";
if (obj_pool.safety > 75)
    {
    prompt += "The water is sparkly and refreshing. ";
    }
else if (obj_pool.safety > 50)
    {
    prompt += "The water seems a little dirty. ";
    }
else if (obj_pool.safety > 25)
    {
    prompt += "The water is green, and smells strange. ";
    }
else
    {
    prompt += "The water is murky and disgusting. ";
    }
prompt += "What will you do?";
//1. Drink it!
//2. Carry some back using 3 tools.
//3. Go back to the wagon.

option[0] = "Dive in and drink it!";
event[0] = event_pool_drink;

if (global.supplies[SUPPLIES.TOOLS] >= 3)
    {
    //can carry some back
    option[1] = "Use 3 tools to carry water back.";
    event[1] = event_pool_carry;
    
    option[2] = "Go back to the wagon.";
    event[2] = event_pool_go_back;
    }
else
    {
    //can't carry any back
    option[1] = "Go back to the wagon.";
    event[1] = event_pool_go_back;
    }


#define event_pool_no
///event_pool_no()

event_parent();

prompt = "You have better things to do with your time than wade in dirty water.";

//continue
background_hspeed[1] = -1;

#define event_pool_drink
///event_pool_drink()

event_parent();

prompt = "You and the family go for a swim and drink some of the water. ";

//roll is a random number, that determines if you can drink the water
//safety is how safe the water is. the higher, the safer.
//if roll < safety, it is safe to drink.
//if roll > safety, it is not safe.
//if roll-safety is too big, it is very unsafe

var roll;
roll = irandom(100);
if (roll < obj_pool.safety+(get_fantastic_count()*5))
    {
    //it was safe
    play_sound(snd_water);
    prompt += "You feel very refreshed and ready to go!";
    var f;
    for (f = 0; f <= 4; f++)
        {
        global.family[f,2]++;
        if (global.family[f,2] > 5)
            {
            feels_fantastic[f] = true;
            global.family[f,2] = 5;
            }
        }
    }
else
    {
    //it wasn't safe!
    play_sound(snd_cough);
    if (roll-obj_pool.safety > 35)
        {
        //very gross.
        prompt += "That water was so putrid, it shouldn't be called water. You feel a lot sicker than before.";
        var f;
        for (f = 0; f <= 4; f++)
            {
            global.family[f,2]--;
            if (global.family[f,2] < 1)
                {
                global.family[f,2] = 1;
                }
            }
        }
    else
        {
        //only a little gross.
        prompt += "The water was disgusting and tasted foul, so you spat it out and went back to the wagon.";
        }
    }

//go on
background_hspeed[1] = -1;

#define event_pool_carry
///event_pool_carry()

event_parent();

global.supplies[SUPPLIES.TOOLS] -= 3;

prompt = "You fill up a few jugs of water and head back to the wagon. ";

var roll;
roll = irandom(100);
if (roll < obj_pool.safety+(get_fantastic_count()*5))
    {
    //it was safe
    play_sound(snd_water);
    prompt += "It's clean and drinkable, so you store it away.";
    if (get_fantastic_count() > 0)
        {
        prompt += " You were even able to squeeze in a bit extra!";
        }
    global.supplies[SUPPLIES.WATER] += floor(global.day/7)+4+get_fantastic_count();
    }
else
    {
    //it wasn't safe!
    play_sound(snd_cough);
    if (roll-obj_pool.safety > 35)
        {
        //very gross.
        prompt += "But pouring that putrid liquid in with the rest of the water was a bad idea. You had to pour some out.";
        global.supplies[SUPPLIES.WATER] = ceil(global.supplies[SUPPLIES.WATER/2]);
        }
    else
        {
        //only a little gross.
        prompt += "But the water is gross, so you had to dump it out or risk getting sick.";
        }
    }

//go on
background_hspeed[1] = -1;

#define event_pool_go_back
///event_pool_go_back()

event_parent();

if (irandom(100) < 20)
    {
    //some food was stolen!
    prompt = "You get back to see the inside of the wagon was all torn up! You find some food was stolen.";
    global.supplies[SUPPLIES.FOOD] = ceil(global.supplies[SUPPLIES.FOOD]/2);
    }
else
    {
    //you got back all fine.
    prompt = "You return to the wagon and hit the road again.";
    }

//move on
background_hspeed[1] = -1;