#define event_wagon
///event_wagon()

obj_wagon2.hspeed = 0;
event_parent();

prompt = "The other wagon stops just ahead of you. You wonder what they could want.";

option[0] = "Call out to the other wagon.";
option[1] = "Let them approach you first.";
option[2] = "Ignore them, get back on the road.";

event[0] = event_wagon_callout;
event[1] = event_wagon_approach;
event[2] = event_wagon_ignore;


#define event_wagon_callout
///event_wagon_callout()

event_parent();

prompt = "You call to the other wagon. ";

if (irandom(100) < 75) && (get_supply_total() < global.day*3) && (global.day >= 4) && (get_fantastic_count() <= 0)
    {
    //help, in your time of need.
    if (irandom(100) < 40+get_total_wellness())
        {
        //they wish they could help you
        prompt = "The other driver calls to you, 'We see your condition and wish we could help... but we can't afford it. Hope you understand.'";
        }
    else
        {
        //they do help you
        prompt = "Out of the kindness of their hearts, the other wagon gives you some supplies.";
        
        global.supplies[SUPPLIES.WOOD] += floor(global.day/5)+choose(0,1,1,2,2,3);
        global.supplies[SUPPLIES.CLOTH] += floor(global.day/5)+choose(0,1,2,2,3,3,4);
        global.supplies[SUPPLIES.TOOLS] += floor(global.day/5)+choose(1,2,3,4,5);
        global.supplies[SUPPLIES.FOOD] += floor(global.day/5)+choose(2,3,3,4,5);
        global.supplies[SUPPLIES.WATER] += floor(global.day/5)+choose(1,2,2,3,4);
        
        set_everybody_fantastic(false);
        }
    
    //move on
    obj_wagon2.hspeed = -2;
    background_hspeed[1] = -1;
    }
else if (irandom(100) < 50+(10*get_fantastic_count()))
    {
    //outcome 1
    var a, c;
    a = choose(
    " rowdy",
    " calm",
    "n overworked",
    "n exhausted",
    " starving",
    "n energetic",
    " depressed",
    "",
    ""
    );
    c = choose(
    "middle-aged man",
    "grandpa",
    "recent mother",
    "pregnant woman",
    "grandma",
    "young child",
    "teenager"
    );
    prompt += "Soon, a"+a+" "+c+" emerges from the wagon and offers you a trade. You give the other wagon "+string(obj_wagon2.demanded_amount)+" "+string_lower(global.supply_names[string(obj_wagon2.demanded)])
    +", and they'll give you "+string(obj_wagon2.offered_amount)+" "+string_lower(global.supply_names[obj_wagon2.offered])+".";
    
    if (global.supplies[obj_wagon2.demanded] >= obj_wagon2.demanded_amount)
        {
        option[0] = "Accept the trade.";
        event[0] = event_wagon_trade;
        }
    else
        {
        option[0] = "You can't accept their trade.";
        event[0] = -1;
        }
        
    option[1] = "Politely decline and continue on.";
    event[1] = event_wagon_decline;
    }
else
    {
    //outcome 2
    prompt += "There is no response from the other wagon.";
    option[0] = "Investigate.";
    option[1] = "Ignore them, get back on the road.";
    event[0] = event_wagon_investigate;
    event[1] = event_wagon_ignore;
    }

#define event_wagon_trade
///event_wagon_trade()

event_parent();

global.supplies[obj_wagon2.demanded] -= obj_wagon2.demanded_amount;
global.supplies[obj_wagon2.offered] += obj_wagon2.offered_amount;

prompt = "You make the exchange, wish them well, and continue on your way.";

if (get_fantastic_count() > 0)
    {
    prompt += " They even gave you a little extra!";
    global.supplies[obj_wagon2.offered] += get_fantastic_count();
    }

background_hspeed[1] = -1;
obj_wagon2.hspeed = -2;

#define event_wagon_approach
///event_wagon_approach()

event_parent();
//1. trade as usual
//2. they attack you
//3. nothing

if (irandom(100) < 50+(8*get_fantastic_count()))
    {
    //trade as normal
    var a, c;
    a = choose(
    " rowdy",
    " calm",
    "n overworked",
    "n exhausted",
    " starving",
    "n energetic",
    " depressed",
    "",
    ""
    );
    c = choose(
    "middle-aged man",
    "grandpa",
    "recent mother",
    "pregnant woman",
    "grandma",
    "young child",
    "teenager"
    );
    prompt = "After a moment, a"+a+" "+c+" emerges from the wagon and proposes a trade. You give the other wagon "+string(obj_wagon2.demanded_amount)+" "+string_lower(global.supply_names[string(obj_wagon2.demanded)])
    +", and they'll give you "+string(obj_wagon2.offered_amount)+" "+string_lower(global.supply_names[obj_wagon2.offered])+".";
    
    if (global.supplies[obj_wagon2.demanded] >= obj_wagon2.demanded_amount)
        {
        option[0] = "Accept the trade.";
        event[0] = event_wagon_trade;
        }
    else
        {
        option[0] = "You can't accept their trade.";
        event[0] = -1;
        }
        
    option[1] = "Politely decline and continue on.";
    event[1] = event_wagon_decline;
    }
else if (irandom(100) < 50-(5*get_fantastic_count()))
    {
    //attack
    var target;
    target = choose(0,1,2,3,4);
    while (global.family[target,0] == FAMILY.NONE)
        {
        target = choose(0,1,2,3,4);
        }
    
    if (irandom(100) < 30+(40*feeling_fantastic[target]))
        {
        //they escape, with a little less wellness
        prompt = "With no warning, the opposing wagon attacks! You were lucky enough to escape, even though "+global.family[target,1]+" sustained some serious injuries.";
        
        if (global.family[target,2] > 2)
            {
            global.family[target,2] = choose(1,2,2); //taken down to 1 or 2 wellness
            }
        else
            {
            global.family[target,2] = 1; //1 wellness left
            }
        }
    else
        {
        //They are killed.
        prompt = "Turns out the wagon was hostile, as they attack you and manage to kill "+global.family[target,1]+". You are forced to flee, or risk losing more family members.";
        play_sound(snd_death);
        global.dead_people += ", "+string(global.family[target,1]);
        
        //kill off
        global.family[target,0] = FAMILY.NONE;
        global.family[target,1] = "Nobody";
        global.family[target,2] = 0;
        
        //CHECK IF GAME OVER
        check_gameover();
        }
    
    //continue on
    background_hspeed[1] = -1;
    obj_wagon2.hspeed = -2;
    }
else
    {
    //nothing
    prompt = "You wait a few minutes, there is still no response. They must have not noticed you.";
    
    option[0] = "Now try calling out to the wagon.";
    event[0] = event_wagon_callout;
    
    option[1] = "Ignore them and slip away.";
    event[1] = event_wagon_ignore;
    }

#define event_wagon_decline
///event_wagon_decline()

event_parent();

prompt = "You apologize, and wish them luck as you continue along the trail.";

background_hspeed[1] = -1;
obj_wagon2.hspeed = -2;

#define event_wagon_investigate
///event_wagon_investigate()

event_parent();

//1. they offer trade now
//2. they attack
//3. they are all dead

if (irandom(100) < 40+(5*get_fantastic_count()))
    {
    //now they offer the trade
    //outcome 1
    var a, c;
    a = choose(
    " mourning",
    "n overworked",
    "n exhausted",
    " starving",
    " depressed",
    "",
    ""
    );
    c = choose(
    "middle-aged man",
    "grandpa",
    "recent mother",
    "pregnant woman",
    "grandma",
    "young child",
    "teenager"
    );
    prompt = "Slowly, a"+a+" "+c+" emerges from the wagon and offers you a trade. You give the other wagon "+string(obj_wagon2.demanded_amount)+" "+string_lower(global.supply_names[string(obj_wagon2.demanded)])
    +", and they'll give you "+string(obj_wagon2.offered_amount)+" "+string_lower(global.supply_names[obj_wagon2.offered])+".";
    
    if (global.supplies[obj_wagon2.demanded] >= obj_wagon2.demanded_amount)
        {
        option[0] = "Accept the trade.";
        event[0] = event_wagon_trade;
        }
    else
        {
        option[0] = "You can't accept their trade.";
        event[0] = -1;
        }
        
    option[1] = "Politely decline and continue on.";
    event[1] = event_wagon_decline;
    }
else if (irandom(100) < 45)
    {
    //they attack
    var target;
    target = choose(0,1,2,3,4);
    while (global.family[target,0] == FAMILY.NONE)
        {
        target = choose(0,1,2,3,4);
        }
    
    if (irandom(100) < 30+(40*feeling_fantastic[target]))
        {
        //they escape, with a little less wellness
        prompt = "With no warning, the opposing wagon attacks! You were lucky enough to escape, even though "+global.family[target,1]+" sustained some serious injuries.";
        
        if (global.family[target,2] > 2)
            {
            global.family[target,2] = choose(1,2,2); //taken down to 1 or 2 wellness
            }
        else
            {
            global.family[target,2] = 1; //1 wellness left
            }
        }
    else
        {
        //They are killed.
        prompt = "Turns out the wagon was hostile, as they attack you and manage to kill "+global.family[target,1]+". You are forced to flee, or risk losing more family members.";
        play_sound(snd_death);
        global.dead_people += ", "+string(global.family[target,1]);
        
        //kill off
        global.family[target,0] = FAMILY.NONE;
        global.family[target,1] = "Nobody";
        global.family[target,2] = 0;
        
        //CHECK IF GAME OVER
        check_gameover();
        }
    
    //continue on
    background_hspeed[1] = -1;
    obj_wagon2.hspeed = -2;
    }
else
    {
    //they are all dead
    prompt = "The stench of rotting flesh hits your nose and a chill runs down your spine, as you peer into the wagon, to find all the inhabitants dead. You move on, knowing there's nothing you could have done.";
    
    background_hspeed[1] = -1;
    obj_wagon2.hspeed = -1;
    }

#define event_wagon_ignore
///event_wagon_ignore()

event_parent();

prompt = "You don't have time for this. You set off, right past them, without a word.";

background_hspeed[1] = -1;
obj_wagon2.hspeed = -2;