#define decide_events
///decide_events()
//Decides what events to pick for today.

flavor_likelihood = irandom(100)+(7*get_fantastic_count())+(5*(2-global.difficulty));
rarity_likelihood = irandom(100)+(6*get_fantastic_count())+(4*(2-global.difficulty));

var cv, iii, lowest, tries, final; cv = 0;
final = setevent_wagon;

//reset the event scripts.
event_script[0] = -1;
event_script[1] = -1;
event_script[2] = -1;

repeat (3)
    {
    //the higher the flavor likelihood, the higher chance you get better events (higher flavor)
    //the higher the rarity likelihood, the higher chance you get rarer events (higher rarity)
    
    tries = 0;
    do
        {
        //actually decide what even we want in here
        //Pick three random events as our candidates.
        for (iii = 0; iii <= 2; iii++)
            {
            if (get_family_count() < 3)
                {
                //to ensure we don't get disease, with only one or two people... also, new person events are biased
                candidate[iii,0] = choose(EVENTS.WAGON,EVENTS.BEGGAR,EVENTS.BEGGAR,EVENTS.BASKET,EVENTS.BASKET,EVENTS.BASKET,EVENTS.INJURY,EVENTS.POOL,EVENTS.WIND,EVENTS.HUNTING,EVENTS.CHOPPING,EVENTS.SUPPLY_CRATE,EVENTS.POISONING);
                }
            else
                {
                if (get_family_count() >= 5)
                    {
                    //baby basket event is disabled
                    candidate[iii,0] = choose(EVENTS.WAGON,EVENTS.BEGGAR,EVENTS.INJURY,EVENTS.POOL,EVENTS.BREAKDOWN,EVENTS.WIND,EVENTS.HUNTING,EVENTS.CHOPPING,EVENTS.DISEASE,EVENTS.SUPPLY_CRATE,EVENTS.ABANDONED,EVENTS.POISONING);
                    }
                else
                    {
                    //all events available
                    candidate[iii,0] = choose(EVENTS.WAGON,EVENTS.BEGGAR,EVENTS.BASKET,EVENTS.INJURY,EVENTS.POOL,EVENTS.BREAKDOWN,EVENTS.WIND,EVENTS.HUNTING,EVENTS.CHOPPING,EVENTS.DISEASE,EVENTS.SUPPLY_CRATE,EVENTS.ABANDONED,EVENTS.POISONING);
                    }
                }
            
            //find the distance from desireability.
            candidate[iii,1] = abs(flavor_likelihood-global.events[candidate[iii,0],0])+abs(rarity_likelihood-global.events[candidate[iii,0],1]);
            }
            
        //now lets select the whose distance is closest to 0.
        lowest = 1000;
        for (iii = 0; iii <= 2; iii++)
            {
            if (candidate[iii,1] < lowest)
                {
                final = candidate[iii,0];
                }
            }
        
        tries++; //failsafe
        }
    until ((global.events[final,2] != event_script[0]) && (final != event_script[1]) ) || (tries > 100)
    
    event_script[cv] = global.events[final,2];
    cv++;//move on to next event
    }

//If we are low on supplies, ensure at least one event will be another wagon.
if (get_supply_total() < 10+global.day)
    {
    event_script[choose(0,1,2)] = global.events[EVENTS.WAGON,2];
    }

#define referece
///just for reference.

//Flavor
/*global.events[EVENTS.WAGON,0] = 90;
global.events[EVENTS.BEGGAR,0] = 70;
global.events[EVENTS.BASKET,0] = 40;
global.events[EVENTS.INJURY,0] = 30;
global.events[EVENTS.POOL,0] = 60;
global.events[EVENTS.BREAKDOWN,0] = 30;
global.events[EVENTS.WIND,0] = 25;
global.events[EVENTS.HUNTING,0] = 60;
global.events[EVENTS.CHOPPING,0] = 60;
global.events[EVENTS.DISEASE,0] = 10; 
global.events[EVENTS.SUPPLY_CRATE,0] = 80;
global.events[EVENTS.ABANDONED,0] = 90;
global.events[EVENTS.POISONING,0] = 15;

//Rarity
global.events[EVENTS.WAGON,1] = 10;
global.events[EVENTS.BEGGAR,1] = 30;
global.events[EVENTS.BASKET,1] = 40;
global.events[EVENTS.INJURY,1] = 10;
global.events[EVENTS.POOL,1] = 50;
global.events[EVENTS.BREAKDOWN,1] = 45;
global.events[EVENTS.WIND,1] = 30;
global.events[EVENTS.HUNTING,1] = 60;
global.events[EVENTS.CHOPPING,1] = 60;
global.events[EVENTS.DISEASE,1] = 65;
global.events[EVENTS.SUPPLY_CRATE,1] = 30;
global.events[EVENTS.ABANDONED,1] = 80;
global.events[EVENTS.POISONING,1] = 55;

*/