#define event_abandoned
///event_abandoned()

event_parent();

prompt = "It's been derelict for quite some time. What will you do?";

if (global.supplies[SUPPLIES.TOOLS] >= 3)
    {
    option[0] = "Attempt to scrap it.";
    event[0] = event_abandoned_scrap;
    
    option[1] = "Check if any supplies are left.";
    event[1] = event_abandoned_check;
    
    option[2] = "Avoid disturbing it.";
    event[2] = event_abandoned_avoid;
    }
else
    {
    option[0] = "Check if any supplies are left.";
    event[0] = event_abandoned_check;
    
    option[1] = "Avoid disturbing it.";
    event[1] = event_abandoned_avoid;
    }


#define event_abandoned_scrap
///event_abandoned_scrap()

event_parent();

global.supplies[SUPPLIES.TOOLS] -= 3;

if (obj_abandoned.occupant != 0)
    {
    //there's somebody in it!?
    event_abandoned_occupant();
    }
else
    {
    //scrap it
    play_sound(snd_supplies);
    play_sound(snd_breakdown);
    var w, c, t;
    w = floor(global.day/4)+choose(3,3,4);
    c = floor(global.day/4)+choose(2,3,3);
    t = floor(global.day/4)+choose(2,2,3);
    
    prompt = "From the wreckage, you recovered "+string(w)+" wood, "+string(c)+" cloth, and "+string(t)+" tools.";
    
    global.supplies[SUPPLIES.WOOD] += w;
    global.supplies[SUPPLIES.CLOTH] += c;
    global.supplies[SUPPLIES.TOOLS] += t;
    
    //move on
    obj_abandoned.visible = false;
    background_hspeed[1] = -1;
    }


#define event_abandoned_check
///event_abandoned_check()

event_parent();

//no tools used

if (obj_abandoned.occupant != 0)
    {
    //there's somebody in it!?
    event_abandoned_occupant();
    }
else
    {
    //scrap it
    play_sound(snd_supplies);
    var f, w;
    f = floor(global.day/5)+choose(1,2,3);
    w = floor(global.day/5)+choose(1,2,2);
    
    prompt = "From the wreckage, you recovered "+string(f)+" food and "+string(w)+" water.";
    
    global.supplies[SUPPLIES.FOOD] += f;
    global.supplies[SUPPLIES.WATER] += w;
    
    //move on
    background_hspeed[1] = -1;
    }


#define event_abandoned_avoid
///event_abandoned_avoid()

event_parent();

prompt = "Messing with that wagon would be a bad idea. Let's just move on.";

//move on
background_hspeed[1] = -1;

#define event_abandoned_occupant
///event_abandoned_occupant()

event_parent();

if (obj_abandoned.occupant == FAMILY.BABY)
    {
    // oh god, its a BABY!?!?
    prompt = "Oh god... there's a baby in the wagon! You don't know how long it's been there, but it's still alive.";
    }
else
    {
    //a normal person? oh jeez
    prompt = "You hear a voice from inside... it looks like a person, too ill to speak!";
    }
    
if (get_family_count() < 5)
    {
    //you can adopt
    option[0] = "Take them with you!"
    event[0] = event_abandoned_adopt;
    }
else
    {
    //can't adopt it
    option[0] = "Sorry, wagon's full. Come again.";
    event[0] = -1;
    }

if (global.supplies[SUPPLIES.FOOD] >= 3) && (global.supplies[SUPPLIES.WATER] >= 3)
    {
    //you could leave some supplies
    option[1] = "Leave some food and water.";
    event[1] = event_abandoned_leave;
    }
else
    {
    //you don't have supplies to leave...
    option[1] = "You don't have any supplies to leave.";
    event[1] = -1;
    }

option[2] = "Take their supplies.";
event[2] = event_abandoned_take;
    
option[3] = "Leave them.";
event[3] = event_abandoned_abandon;

#define event_abandoned_adopt
///event_abandoned_adopt()

event_parent();

if (obj_abandoned.occupant == FAMILY.BABY)
    {
    prompt = "You name the baby "+obj_abandoned.occupant_name+", and decide to raise them right.";
    }
else
    {
    prompt = "You welcome your newest family member, "+obj_abandoned.occupant_name+", onto the wagon.";
    }

//Add here
var f;
for (f = 0; f <= 4; f++)
    {
    if (global.family[f,0] == FAMILY.NONE)
        {
        global.family[f,0] = obj_abandoned.occupant;
        global.family[f,1] = obj_abandoned.occupant_name;
        global.family[f,2] = 1;
        break;
        }
    }

global.event_score += 100;

//continue
background_hspeed[1] = -1;

#define event_abandoned_leave
///event_abandoned_leave()

event_parent();

global.supplies[SUPPLIES.FOOD] -= 3;
global.supplies[SUPPLIES.WATER] -= 3;

prompt = "There's nothing more you can do for them other than leave food and water. You set off.";

//make everybody feel fantastic
set_everybody_fantastic(true);

//move on
background_hspeed[1] = -1;

#define event_abandoned_take
///event_abandoned_take()

event_parent();

play_sound(snd_supplies);

global.supplies[SUPPLIES.TOOLS] += choose(2,3,3,4,4);
global.supplies[SUPPLIES.FOOD] += choose(1,2);
global.supplies[SUPPLIES.WATER] += choose(1,1,2);

prompt = "You can't help but feel horrible afterward. But hey, these are tough times, you need whatever you can get.";

//make nobody feel fantastic
set_everybody_fantastic(false);

global.event_score -= 120;

//move on
background_hspeed[1] = -1;

#define event_abandoned_abandon
///event_abandoned_abandon()

event_parent();

prompt = "All you can do is hope that they'll be OK after all is said and done.";

global.event_score -= 30;

//move on
background_hspeed[1] = -1;
