#define event_troll
///event_troll()
//Occurs when reaching a bridge.

event_parent();

background_hspeed[1] = 0;
if (global.day <= 1)
    {
    prompt = "The troll stops you short. In order to pass this bridge, he says, you must pay tribute.";
    }
else
    {
    prompt = choose(
    "The troll stops you short. In order to pass this bridge, he says, you must pay tribute.",
    "The troll is blocking the bridge and you're forced to stop. He demands you pay to keep going.",
    "Angrily, the troll demands you pay up if you want to continue on the other side.",
    "Trolls aren't known for being cooperative. But if you pay, you can pass by.",
    "Now this is extortion, that's what it is!",
    "Maybe if you ask really nicely... just kidding.",
    "How does the economy around these parts even function if every dang bridge has a toll!?",
    "This troll seems kind enough. Too bad he's still charging you for passage.",
    "You may have to sacrifice something to get across the bridge here..."
    );
    }

prompt += " The tribute for this bridge is "+string(obj_troll.demanded_amount)+" "+global.supply_names[obj_troll.demanded]+".";

var f, supply_total; f = 0; supply_total = 0;
for (f = 0; f <= 4; f++)
    {
    supply_total += global.supplies[f];
    }

if (global.supplies[obj_troll.demanded] >= obj_troll.demanded_amount)
    {
    option[0] = "Pay the tribute.";
    event[0] = event_paytribute;
    }
else
    {
    //Can't pay it!
    option[0] = "You can't afford that!";
    event[0] = -1;
    }

if (supply_total > 0)
    {
    option[1] = "Try making a different offer.";
    event[1] = event_offer;
    }
else
    {
    //Don't have anything to make an offer with!
    option[1] = "You can't offer another trade.";
    event[1] = -1;
    }

//Last resort option, always available.
option[2] = "Fight the troll!";
event[2] = event_fight;

#define event_paytribute
///event_paytribute()
//Occurs when tribute is paid to a troll.

event_parent();

//reduce the supplies
global.supplies[obj_troll.demanded] -= obj_troll.demanded_amount;

background_hspeed[1] = -1;

if (!paid_tribute_before)
    {
    prompt = "You hand over the tribute, and continue on the trail.";
    paid_tribute_before = true;
    }
else
    {
    prompt = choose(
    "You hand over the tribute, and continue on the trail.",
    "Grudgingly, you pay and keep going.",
    "Reluctantly, you hand it over and set off once again.",
    "Too bad these trolls are all so greedy.",
    "Good thing you paid tribute this time.",
    "That sacrifice may not have been worth it, but it's hard to say.");
    }
obj_troll.paid = true;

alarm[1] = 200;

#define event_offer
///event_offer()

event_parent();

if (!offered_supplies_before)
    {
    prompt = "You take a look at your supplies.";
    offered_supplies_before = true;
    }
else
    {
    prompt = choose(
    "You take a look at your supplies.",
    "You rummage through your supplies, to try and find something tradable.",
    "What would trolls want more than the tribute cost?",
    "Trolls sure are mysterious creatures. What could he want?",
    "Maybe something you have could be a better offer."
    );
    }

var f, am;
for (f = 0; f <= 4; f++)
    {
    if (global.supplies[f] > 0)
        {
        am = max(1,ceil(global.supplies[f]*0.4));
        option[f] = "Offer "+string(am)+" "+global.supply_names[f]+".";
        event[f] = event_offer_selection;
        }
    else
        {
        option[f] = "You cannot offer "+global.supply_names[f]+".";
        event[f] = -1;
        }
    }

#define event_offer_selection
///event_offer_selection()

//"chosen" holds the supply you chose to give up.

var offered_amount, needed_amount, difference, n, ff;
ff = feeling_fantastic[0]+feeling_fantastic[1]+feeling_fantastic[2]+feeling_fantastic[3]+feeling_fantastic[4];
offered_amount = (max(1,ceil(global.supplies[chosen]*0.25))*obj_troll.bias[chosen])+ff;
needed_amount = obj_troll.demanded_amount*obj_troll.bias[obj_troll.demanded];

difference = offered_amount-needed_amount;
n = string_lower(global.supply_names[chosen]);

if (difference > 8)
    {
    prompt = "Overjoyed, the troll happily takes your "+n+" and lets you pass.";
    }
else if (difference > 5)
    {
    prompt = "The troll seems more than satisfied with the new offer, and you get to pass.";
    }
else if (difference > 2)
    {
    prompt = "The troll seems indifferent about the offer but accepts it anyways.";
    }
else if (difference >= 0)
    {
    prompt = "Grumbling, he accepts your petty "+n+" and lets you get going.";
    }
else if (difference > -3)
    {
    prompt = "The troll politely declines your offer.";
    }
else if (difference > -7)
    {
    prompt = "Scoffing, the troll rejects the "+n+" and continues to block the path.";
    }
else if (difference > -10)
    {
    prompt = "The troll burst out in laughter at the miserable offer.";
    }
else if (difference <= -10)
    {
    prompt = "Your offer is so pathetic, the troll isn't even laughing.";
    }

if (offered_amount >= needed_amount)
    {
    //Offer accepted
    global.supplies[chosen] -= max(1,ceil(global.supplies[chosen]*0.25));
    obj_troll.paid = true;

    background_hspeed[1] = -1; //continue the journey
    alarm[1] = 200;
    }
else
    {
    //Offer rejected
    //Wait 60 steps or so, and go back to original menu
    
    alarm[3] = 60;
    }
    
event_parent();

#define event_fight
///event_fight()

event_parent();

if (!fought_troll_before)
    {
    prompt = "Trolls never back down from a challenge. Which of your family members will fight the troll?";
    fought_troll_before = true;
    }
else
    {
    prompt = choose(
    "Trolls never back down from a challenge. Which of your family members will fight the troll?",
    "Who is going to fight this one?",
    "Oh no, another fight. Hopefully you can win.",
    "Risk versus reward. You won't have to pay supplies, but one of your family members might have to pay in blood.",
    "Who is willing to make the sacrifice this time?",
    "It's for the greater good. When the fight happens, you can slip by."
    );
    }

var f;
for (f = 0; f <= 4; f++)
    {
    if (global.family[f,0] != FAMILY.NONE)
        {
        option[f] = global.family[f,1];
        event[f] = event_fight_selection;
        }
    else
        {
        option[f] = "N/A";
        event[f] = -1;
        }
    }


#define event_fight_selection
///event_fight_selection()
//Occurs when you send a family member to fight the troll.

event_parent();

//The variable "chosen" holds the family member you selected.

var victory, n, attack, defense, margin, pronoun;

// type * multiplier * random
attack = global.family[chosen,2]*global.multiplier[global.family[chosen,0]]*random_range(0.9,1.1)+feeling_fantastic[chosen];
defense = obj_troll.strength*random_range(0.9,1.1);

margin = attack-defense;
victory = (attack > defense);
n = global.family[chosen,1]; //name

if (global.family[chosen,0] == FAMILY.WOMAN) || (global.family[chosen,0] == FAMILY.OLD_WOMAN)
    {
    pronoun = "her";
    } else {
    pronoun = "his";
    }

if (margin > 8)
    {
    txt = "After a few quick seconds, you can't even tell there used to be a troll here.";
    }
else if (margin > 4)
    {
    txt = "With almost no effort, "+n+" completely demolished that poor troll.";
    }
else if (margin > 3)
    {
    txt = "After a brief fight, "+n+" emerged victorious.";
    }
else if (margin > 2)
    {
    txt = n+" had the clear advantage this time, and won after a short battle.";
    }
else if (margin > 1)
    {
    txt = "It was a close one, but "+n+" managed to defeat the troll!";
    }
else if (margin > 0)
    {
    txt = n+" beat the troll, but only survived by the skin of "+pronoun+" teeth!"
    }
else if (margin > -1)
    {
    txt = "It was very close, but "+n+" was killed. You managed to barely escape.";
    }
else if (margin > -2)
    {
    txt = "The troll had the advantage this time, and "+n+" was killed. Let's hope the sacrifice was worth it.";
    }
else if (margin > -3)
    {
    txt = n+" was really taking a beating, and was killed after a minute or two. You made it past, however.";
    }
else if (margin > -4)
    {
    txt = "Poor "+n+". That death looked like it hurt, a lot. At least "+pronoun+" sacrifice let you get past the troll."
    }
else if (margin > -10)
    {
    txt = "You'll never get the image of that fight out of your head. You slip by the troll, plagued by your guilt of sending "+n+" to a gruesome end.";
    }
else if (margin <= -10)
    {
    txt = "The only thing left of "+n+" is a small bone under the bridge, and a speck of blood on your canopy.";
    }
    
prompt = txt;
if (!victory)
    {
    //One last chance to survive, if they are feeling fantastic...
    if (feeling_fantastic[chosen]) && (irandom(100) < 40)
        {
        //They survived by some miracle!
        if (!survived_by_a_miracle_before)
            {
            prompt = "You don't know how, but somehow, "+n+" after being severely injured, survived and caught up with you!";
            survived_by_a_miracle_before = true;
            }
        else
            {
            prompt = choose(
            "You don't know how, but somehow, "+n+" after being severely injured, survived and caught up with you!",
            "You thank god, as you find "+n+" somehow caught up with you after badly losing the fight!",
            "You just got a miracle. "+n+" lost, badly, but is surviving and managed to catch up to you.",
            n+" just got very lucky, and managed to escape the troll before certain death, despite all those injuries."
            );
            }
        global.family[chosen,2] = choose(1,1,2);
        }
    else
        {
        //kill off the family member
        play_sound(snd_death);
        global.dead_people += ", "+global.family[chosen,1];
        global.family[chosen,0] = FAMILY.NONE;
        global.family[chosen,1] = "Nobody";
        global.family[chosen,2] = 0;
        feeling_fantastic[chosen] = false;
        }
    
    obj_troll.paid = true;
    
    //CHECK IF THE WHOLE FAMILY IS DEAD.
    check_gameover();
    }
else
    {
    //destroy the troll
    global.defeated_trolls++;
    instance_create(obj_troll.x+(obj_troll.image_xscale*12),obj_troll.y-(obj_troll.image_yscale*12),obj_spark);
    obj_spark.image_xscale = obj_troll.image_xscale;
    obj_spark.image_yscale = obj_troll.image_yscale;
    with (obj_troll)
        {
        instance_destroy();
        }
    }

play_sound(snd_fight);
background_hspeed[1] = -1; //continue the journey

alarm[1] = 200;

#define event_parent
///event_parent()
//This event is the parent of all prompt events... it resets your options

var f;
for (f = 0; f <= 4; f++)
    {
    option[f] = "";
    event[f] = -1;
    }