///scr_textbox("Text",x,y,skipqueue,portrait);

var obj;

if (argument_count < 4) || (argument[3] != 1)
{
    if (!instance_exists(obj_text)) obj = obj_text; else obj = obj_text_queued;
    var textbox = instance_create(argument[1],argument[2],obj);
}
else
{
    var textbox = instance_create(argument[1],argument[2],obj_text);
}

with (textbox)
{
    //Settings
    turbo = global.txt_turbo;
    gradient = global.txt_gradient;
    padding = global.txt_padding;
    bg = global.txt_bg;
    bg_c = global.txt_bg_c;
    bg_a = global.txt_bg_a;
    if (gradient) bg_c2 = global.txt_bg_c2;
    hscroll = global.txt_hscroll;
    vscroll = global.txt_vscroll;
    maxlength = global.txt_maxlength; //Not size of box, only size of text, fix me!
    font = global.txt_font;
    border_sprite = global.txt_border;
    sound = global.txt_sound;
    view = global.txt_view
    font_size = global.txt_font_size
    spd = 0.4; //default speed
    text = argument[0];
    lines = 0;
    linebreak[0] = 0;
    linesep = global.txt_linesep;
    draw_set_font(fnt_s);
    glyph = fnt_s
    
    //Build final string and compile special flags
    var temptext = "";
    var tcol = c_white;
    var tspd = spd;
    var tshk = 0;
    var tfnt = fnt_s;
    var twav = 0;
    var spec = 0;
    var ttwn = 0;
    var tmod = 0;
    
    var thislinewidth = 0;
    var maxwidth = 0;

    //Tag Interpreter
    for (i = 1; i <= string_length(text); i++)
    {
        switch (string_char_at(text, i))
        {
            case "["://tag start found 
            {
                var j = 1;
                var cap = min(25,string_length(text)-i);
                while (j < cap) && (string_char_at(text,i+j) != "]") j++;
                if (j < cap) //tag end found
                {
                    var command = string_copy(text,i+1,j-1);
                    var commandval = real(string_digits(command));
                    command = string_letters(command);
                    text = string_delete(text,i,j+1);
                    i--;
                    
                    switch (command)
                    {
                        case "RED": tcol = c_red; break;
                        case "WHITE": tcol = c_white; break;
                        case "AQUA": tcol = c_aqua; break;
                        case "DCOL": tcol = c_white; break;
                        case "SPEED": tspd = commandval*0.1; break;
                        case "GLYPH": tfnt = glyph; break;
                        case "FONT": tfnt = commandval; break; 
                        case "TWEEN": ttwn = commandval; break; 
                        case "WAVE": twav = commandval; break; 
                        case "SHAKE": tshk = commandval; break; 
                        case "BR": //linebreak
                        {
                            linebreak[lines] = i;
                            linewidth[lines] = string_width(string_copy(text,1,i));
                            if (lines > 0) linewidth[lines] = string_width(string_copy(temptext,linebreak[lines-1],i-linebreak[lines-1]));
                            lines++;
                            maxwidth = max(maxwidth,thislinewidth);
                            thislinewidth = 0;
                            break;
                        }
                    }
                }
                else //broken tag
                {
                    text = string_delete(text,i,1);
                    i--;
                }
                break;
            }
            default:
            {
                thetext[i,letter.cha]  = string_char_at(text, i);
                thetext[i,letter.col]  = tcol;
                thetext[i,letter.spd]  = tspd;
                thetext[i,letter.shk]  = tshk;
                thetext[i,letter.fot]  = tfnt;
                thetext[i,letter.wav]  = twav;
                thetext[i,letter.twn]  = ttwn;
                //temptext = string_insert(thetext[i-spec,letter.cha],temptext,i);
                draw_set_font(tfnt);
                thislinewidth += string_width(string_char_at(text, i));
                break;
            }
        }
    }
    //text = temptext;
    maxwidth = max(maxwidth,thislinewidth);
    
    //Initialize text box based on settings
    text_length = string_length(text); //done twice intentionally
    shakey[text_length]=0;
    shakex[text_length]=0;
    
    if (font_size == 0) font_size = font_get_size(font);
    text_width = maxwidth;
    text_height = lines * font_size + ((lines+2) * font_size/2);
    border_sprite_w = abs(sprite_get_width(border_sprite));
    
    if (argument_count == 5) portrait = argument[4]; else portrait = -1;
    if (portrait != -1) 
    {
        portrait_w = sprite_get_width(portrait);
        portrait_h = sprite_get_height(portrait);
        portrait_n = sprite_get_number(portrait);
    }
    else 
    {
        portrait_w = 0;
        portrait_h = 0;
    }

    boxwidth = (ceil(text_width/border_sprite_w)*border_sprite_w) +(padding*2) + portrait_w + (sign(portrait_w)*padding)
    if (string_width(text) > maxlength) boxwidth = maxlength + padding*2
    
    boxheight = max
    (
        (ceil (text_height/border_sprite_w) * border_sprite_w) + (padding*2),
        (ceil (global.txt_minheight/border_sprite_w) * border_sprite_w),
        (padding*2) + portrait_h,
    );

    var pos = global.txt_forceposition
    
    pointer_x = x;
    switch (pos)
    {
        default:
        x -= boxwidth*global.txt_boxalign_h;
        y -= boxheight*global.txt_boxalign_v;
        break;
        case 1:
        y = view_yview[view] + view_hview[view] - boxheight - border_sprite_w/2;
        x = view_xview[view] + border_sprite_w/2;
        boxwidth = view_wview[view] - border_sprite_w;
        break;
        case 2:
        y = view_yview[view] + border_sprite_w/2;
        x = view_xview[view] + border_sprite_w/2;
        boxwidth = view_wview[view] - border_sprite_w;
        break;
    }
}
