/// @description Insert description here
// You can write your code in this editor

alarm[0] = 20;
switch (sprite_index) {
	//ground type
	case spr_skeleton:
		switch (state) {
			default:
			//idle
				//chance to walk around
				if (!irandom(60)) {
					state = AI.walk;
					dir = choose(180,0);
					spd = 0.1+random(0.4);
				}
				//if close start to chase
				if (distance_to_object(Player) < 300) {
					state = AI.wary;
				}
			break;
			case AI.walk:
				//chance to stop
				if (!irandom(70)) {
					state = AI.idle;
					spd = 0;
				}
				//if close start to chase
				if (distance_to_object(Player) < 300) {
					state = AI.wary;
					spd = 1;
					if (sign(x-Player.x)) {
						dir = 180;
					} else {
						dir = 0;
					}
				}
			break;
			case AI.wary:
				//chance to stop chase
				if (distance_to_object(Player) >= 300) {
					state = AI.idle;
					spd = 0;
				} else if (distance_to_object(Player) < 150) {
				//close in
					state = AI.attack;
					if (sign(x-Player.x)) {
						dir = 180;
					} else {
						dir = 0;
					}
					spd = 1.5;
				}
			break;
			case AI.attack:
				//chance to stop chase
				if (distance_to_object(Player) >= 150) {
					state = AI.wary;
					spd = 2.5;
				} else if (distance_to_object(Player) <= 15) {
					//hit player
					if (!Player.hurt) {
						Player.hurt=true;
						Player.hurt_timer=40;
						global.HP -= 35 - (global.armor*4);
					}
					alarm[1] = 60;
					state = AI.run;
					spd = 1;
					if (sign(x-Player.x)) {
						dir = 0;
					} else {
						dir = 180;
					}
				}
			break;
			case AI.run:
				
			break;
			case AI.hurt:
				if (!hurt_timer) {
					state = AI.idle;	
				} else { hurt_timer--; }
			break;
			case AI.dying:
				if (!hurt_timer) {
					instance_destroy(self);
				} else {hurt_timer--;}
			break;
		}
	break;
	
	case spr_slime:
		switch (state) {
			default:
			//idle
				//chance to walk around
				if (!irandom(30)) {
					state = AI.walk;
					dir = choose(180,0);
				}
				//if close start to chase
				if (distance_to_object(Player) < 300) {
					state = AI.wary;
				}
			break;
			case AI.walk:
				//chance to stop
				if (!irandom(70)) {
					state = AI.idle;
				}
				//if close start to chase
				if (distance_to_object(Player) < 300) {
					state = AI.wary;
					spd = 1;
					if (sign(x-Player.x)) {
						dir = 180;
					} else {
						dir = 0;
					}
				}
			break;
			case AI.wary:
				//chance to stop chase
				if (distance_to_object(Player) >= 300) {
					state = AI.idle;
					spd = 0;
				} else if (distance_to_object(Player) < 150) {
				//close in
					state = AI.attack;
					if (sign(x-Player.x)) {
						dir = 180;
					} else {
						dir = 0;
					}
					spd = 1.5;
				}
			break;
			case AI.attack:
				//chance to stop chase
				if (distance_to_object(Player) >= 150) {
					state = AI.wary;
				} else if (distance_to_object(Player) <= 15) {
				//hit player
					if (!Player.hurt) {
						Player.hurt=true;
						Player.hurt_timer=40;
						global.HP -= 35 - (global.armor*4);
					}
					image_index = 0;
					alarm[1] = 160;
					state = AI.run;
					if (sign(x-Player.x)) {
						dir = 0;
					} else {
						dir = 180;
					}
				}
			break;
			case AI.run:
				
			break;
			case AI.hurt:
				if (!hurt_timer) {
					state = AI.idle;	
				} else { hurt_timer--; }
			break;
			case AI.dying:
				if (!hurt_timer) {
					instance_destroy(self);
				} else {hurt_timer--;}
			break;
		}
	break;
	
	case spr_hand:
		switch (state) {
			default:
				image_index = 0;
				if (distance_to_object(Player)<35) {
					state = AI.attack;
				}
			break;
			case AI.attack:
				image_speed = 0.8;
				if (image_index >= 5) && (distance_to_object(Player)<=16) {
				//hurt player
					if (!Player.hurt) {
						Player.hurt=true;
						Player.hurt_timer=40;
						global.HP -= 35 - (global.armor*4);
					}
					state = AI.run;
				}
			break;
			case AI.run:
				image_speed = 1;
			break;
			case AI.hurt:
				if (!hurt_timer) {
					state = AI.idle;	
				} else { hurt_timer--; }
			break;
			case AI.dying:
				if (!hurt_timer) {
					instance_destroy(self);
				} else {hurt_timer--;}
			break;
		}
	break;
	
	//flying type
	
	case spr_eye:
		switch (state) {
			default:
			//idle
				//chance to walk around
				if (!irandom(5)) {
					state = AI.walk;
					dir = irandom(360);
					if (y < 300) {
						dir = irandom_range(200, 340);
						if (x <= Player.x - 300) {
							dir = irandom_range(200, 240);	
						}
						if (x >= Player.x + 300) {
							dir = irandom_range(300, 340);	
						}
					}
					if (y >= Player.y - 32) {
						dir = irandom_range(20, 160);
						if (x <= Player.x - 300) {	
							dir = irandom_range(20, 60);
						}
						if (x >= Player.x + 300) {
							dir = irandom_range(120, 160);	
						}
					}
				}
				//if close start to chase
				if (distance_to_object(Player) < 450) {
					state = AI.wary;
					dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				}
			break;
			case AI.walk:
				spd = lerp(spd, 3, 0.15);
				if (y < 300) {
					dir = irandom_range(200, 340);
					if (x <= Player.x - 300) {
						dir = irandom_range(200, 240);	
					}
					if (x >= Player.x + 300) {
						dir = irandom_range(300, 340);	
					}
				}
				if (y >= Player.y - 32) {
					dir = irandom_range(20, 160);
					if (x <= Player.x - 300) {	
						dir = irandom_range(20, 60);
					}
					if (x >= Player.x + 300) {
						dir = irandom_range(120, 160);	
					}
				}
				
				//chance to stop
				if (!irandom(30)) {
					state = AI.idle;
				}
				//if close start to chase
				if (distance_to_object(Player) < 350) {
					state = AI.wary;
					dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				}
			break;
			case AI.wary:
				spd = lerp(spd, 3, 0.15);
				dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				
				//chance to stop chase
				if (distance_to_object(Player) >= 350) {
					state = AI.idle;
				} else if (distance_to_object(Player) < 150) {
				//close in
					state = AI.attack;
					spd = lerp(spd, 3.5, 0.15);
					dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				}
			break;
			case AI.attack:
				spd = lerp(spd, 3.5, 0.15);
				dir = point_direction(x, y, Player.x, Player.y-16);
				//chance to stop chase
				if (distance_to_object(Player) >= 150) {
					state = AI.wary;
				} else if (distance_to_object(Player) <= 8) {
				//hit player
					if (!Player.hurt) {
						Player.hurt=true;
						Player.hurt_timer=40;
						global.HP -= 35 - (global.armor*4);
					}
					alarm[1] = 180;
					state = AI.run;
					spd = lerp(spd, 4.5, 0.25);
					dir = point_direction(Player.x, Player.y, x, y);
				}
			break;
			case AI.run:
				spd = lerp(spd, 0, 0.1);
			break;
			case AI.hurt:
				if (!hurt_timer) {
					state = AI.idle;	
				} else { hurt_timer--; }
			break;
			case AI.dying:
				if (!hurt_timer) {
					instance_destroy(self);
				} else {hurt_timer--;}
			break;
		}
	break;
	case spr_jacko:
		switch (state) {
			default:
			//idle
				//chance to walk around
				if (!irandom(5)) {
					state = AI.walk;
					dir = irandom(360);
					if (y < 300) {
						dir = irandom_range(200, 340);
						if (x <= Player.x - 300) {
							dir = irandom_range(200, 240);	
						}
						if (x >= Player.x + 300) {
							dir = irandom_range(300, 340);	
						}
					}
					if (y >= Player.y - 32) {
						dir = irandom_range(20, 160);
						if (x <= Player.x - 300) {	
							dir = irandom_range(20, 60);
						}
						if (x >= Player.x + 300) {
							dir = irandom_range(120, 160);	
						}
					}
				}
				//if close start to chase
				if (distance_to_object(Player) < 450) {
					state = AI.wary;
					dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				}
			break;
			case AI.walk:
				spd = lerp(spd, 3, 0.15);
				if (y < 300) {
					dir = irandom_range(200, 340);
					if (x <= Player.x - 300) {
						dir = irandom_range(200, 240);	
					}
					if (x >= Player.x + 300) {
						dir = irandom_range(300, 340);	
					}
				}
				if (y >= Player.y - 32) {
					dir = irandom_range(20, 160);
					if (x <= Player.x - 300) {	
						dir = irandom_range(20, 60);
					}
					if (x >= Player.x + 300) {
						dir = irandom_range(120, 160);	
					}
				}
				
				//chance to stop
				if (!irandom(30)) {
					state = AI.idle;
				}
				//if close start to chase
				if (distance_to_object(Player) < 350) {
					state = AI.wary;
					dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				}
			break;
			case AI.wary:
				spd = lerp(spd, 3, 0.15);
				dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				
				//chance to stop chase
				if (distance_to_object(Player) >= 350) {
					state = AI.idle;
				} else if (distance_to_object(Player) < 150) {
				//close in
					state = AI.attack;
					spd = lerp(spd, 3.5, 0.15);
					dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				}
			break;
			case AI.attack:
				spd = lerp(spd, 3.5, 0.15);
				dir = point_direction(x, y, Player.x, Player.y-16);
				//chance to stop chase
				if (distance_to_object(Player) >= 150) {
					state = AI.wary;
				} else if (distance_to_object(Player) <= 8) {
				//hit player
					if (!Player.hurt) {
						Player.hurt=true;
						Player.hurt_timer=40;
						global.HP -= 35 - (global.armor*4);
					}
					alarm[1] = 180;
					state = AI.run;
					spd = lerp(spd, 4.5, 0.25);
					dir = point_direction(Player.x, Player.y, x, y);
				}
			break;
			case AI.run:
				spd = lerp(spd, 0, 0.1);
			break;
			case AI.hurt:
				if (!hurt_timer) {
					state = AI.idle;	
				} else { hurt_timer--; }
			break;
			case AI.dying:
				if (!hurt_timer) {
					instance_destroy(self);
				} else {hurt_timer--;}
			break;
		}
	break;
	case spr_bat:
		switch (state) {
			default:
			//idle
				//chance to walk around
				if (!irandom(5)) {
					state = AI.walk;
					dir = irandom(360);
					if (y < 300) {
						dir = irandom_range(200, 340);
						if (x <= Player.x - 300) {
							dir = irandom_range(200, 240);	
						}
						if (x >= Player.x + 300) {
							dir = irandom_range(300, 340);	
						}
					}
					if (y >= Player.y - 32) {
						dir = irandom_range(20, 160);
						if (x <= Player.x - 300) {	
							dir = irandom_range(20, 60);
						}
						if (x >= Player.x + 300) {
							dir = irandom_range(120, 160);	
						}
					}
				}
				//if close start to chase
				if (distance_to_object(Player) < 450) {
					state = AI.wary;
					dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				}
			break;
			case AI.walk:
				spd = lerp(spd, 3, 0.15);
				if (y < 300) {
					dir = irandom_range(200, 340);
					if (x <= Player.x - 300) {
						dir = irandom_range(200, 240);	
					}
					if (x >= Player.x + 300) {
						dir = irandom_range(300, 340);	
					}
				}
				if (y >= Player.y - 32) {
					dir = irandom_range(20, 160);
					if (x <= Player.x - 300) {	
						dir = irandom_range(20, 60);
					}
					if (x >= Player.x + 300) {
						dir = irandom_range(120, 160);	
					}
				}
				
				//chance to stop
				if (!irandom(30)) {
					state = AI.idle;
				}
				//if close start to chase
				if (distance_to_object(Player) < 350) {
					state = AI.wary;
					dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				}
			break;
			case AI.wary:
				spd = lerp(spd, 3, 0.15);
				dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				
				//chance to stop chase
				if (distance_to_object(Player) >= 350) {
					state = AI.idle;
				} else if (distance_to_object(Player) < 150) {
				//close in
					state = AI.attack;
					spd = lerp(spd, 3.5, 0.15);
					dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				}
			break;
			case AI.attack:
				spd = lerp(spd, 3.5, 0.15);
				dir = point_direction(x, y, Player.x, Player.y-16);
				//chance to stop chase
				if (distance_to_object(Player) >= 150) {
					state = AI.wary;
				} else if (distance_to_object(Player) <= 8) {
				//hit player
					if (!Player.hurt) {
						Player.hurt=true;
						Player.hurt_timer=40;
						global.HP -= 35 - (global.armor*4);
					}
					alarm[1] = 180;
					state = AI.run;
					spd = lerp(spd, 4.5, 0.25);
					dir = point_direction(Player.x, Player.y, x, y);
				}
			break;
			case AI.run:
				spd = lerp(spd, 0, 0.1);
			break;
			case AI.hurt:
				if (!hurt_timer) {
					state = AI.idle;	
				} else { hurt_timer--; }
			break;
			case AI.dying:
				if (!hurt_timer) {
					instance_destroy(self);
				} else {hurt_timer--;}
			break;
		}
	break;
	case spr_ghost:
		switch (state) {
			default:
			//idle
				//chance to walk around
				if (!irandom(5)) {
					state = AI.walk;
					dir = irandom(360);
					if (y < 300) {
						dir = irandom_range(200, 340);
						if (x <= Player.x - 300) {
							dir = irandom_range(200, 240);	
						}
						if (x >= Player.x + 300) {
							dir = irandom_range(300, 340);	
						}
					}
					if (y >= Player.y - 32) {
						dir = irandom_range(20, 160);
						if (x <= Player.x - 300) {	
							dir = irandom_range(20, 60);
						}
						if (x >= Player.x + 300) {
							dir = irandom_range(120, 160);	
						}
					}
				}
				//if close start to chase
				if (distance_to_object(Player) < 450) {
					state = AI.wary;
					dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				}
			break;
			case AI.walk:
				spd = lerp(spd, 3, 0.15);
				if (y < 300) {
					dir = irandom_range(200, 340);
					if (x <= Player.x - 300) {
						dir = irandom_range(200, 240);	
					}
					if (x >= Player.x + 300) {
						dir = irandom_range(300, 340);	
					}
				}
				if (y >= Player.y - 32) {
					dir = irandom_range(20, 160);
					if (x <= Player.x - 300) {	
						dir = irandom_range(20, 60);
					}
					if (x >= Player.x + 300) {
						dir = irandom_range(120, 160);	
					}
				}
				
				//chance to stop
				if (!irandom(30)) {
					state = AI.idle;
				}
				//if close start to chase
				if (distance_to_object(Player) < 350) {
					state = AI.wary;
					dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				}
			break;
			case AI.wary:
				spd = lerp(spd, 3, 0.15);
				dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				
				//chance to stop chase
				if (distance_to_object(Player) >= 350) {
					state = AI.idle;
				} else if (distance_to_object(Player) < 150) {
				//close in
					state = AI.attack;
					spd = lerp(spd, 3.5, 0.15);
					dir = point_direction(x, y, Player.xprevious, Player.yprevious);
				}
			break;
			case AI.attack:
				spd = lerp(spd, 3.5, 0.15);
				dir = point_direction(x, y, Player.x, Player.y-16);
				//chance to stop chase
				if (distance_to_object(Player) >= 150) {
					state = AI.wary;
				} else if (distance_to_object(Player) <= 8) {
				//hit player
					if (!Player.hurt) {
						Player.hurt=true;
						Player.hurt_timer=40;
						global.HP -= 35 - (global.armor*4);
					}
					alarm[1] = 180;
					state = AI.run;
					spd = lerp(spd, 4.5, 0.25);
					dir = point_direction(Player.x, Player.y, x, y);
				}
			break;
			case AI.run:
				spd = lerp(spd, 0, 0.1);
			break;
			case AI.hurt:
				if (!hurt_timer) {
					state = AI.idle;	
				} else { hurt_timer--; }
			break;
			case AI.dying:
				if (!hurt_timer) {
					instance_destroy(self);
				} else {hurt_timer--;}
			break;
		}
	break;
}