/// @description Insert description here
// You can write your code in this editor

if (state != AI.hurt) && (state != AI.dying) && (!ds_list_find_value(hurt_from_list, other.id)) {
	switch (other.sprite_index) {
		default:
		//bolt
			hp -= 35;
			ds_list_add(hurt_from_list, other.id);
			if (hp > 0) {
				state = AI.hurt;
				hurt_timer = 0;
				if (other.pDir > 0) {
					dir = 180;
				} else {
					dir = 0;	
				}
				spd = 4;
				with (other) {
					active = true;
					image_speed = 1;
					pSpd /= 2;
				}
			} else {
				state = AI.dying;
				hurt_timer = 3;
				//spill coins
				global.mobsKilled++;
				global.mobsKilledThisRound++;
					for (var i=0; i<1+(returnValue(sprite_index)/2); i++) {
						instance_create_layer(x, y-16, layer, Coin);
					}
			}
		break;
		case spr_wave:
			hp -= 22;
			if (hp > 0) {
				state = AI.hurt;
				hurt_timer = 1;
				if (other.pDir > 0) {
					dir = 180;
				} else {
					dir = 0;	
				}
				spd = 6;
			} else {
				state = AI.dying;
				hurt_timer = 3;
				//spill coins
				global.mobsKilled++;
				global.mobsKilledThisRound++;
					for (var i=0; i<1+(returnValue(sprite_index)/2); i++) {
						instance_create_layer(x, y-16, layer, Coin);
					}
			}
		break;
		case spr_lob:
			hp -= 55;
			ds_list_add(hurt_from_list, other.id);
			if (hp > 0) {
				state = AI.hurt;
				hurt_timer = 0;
				if (other.direction >= 270) || (other.direction < 90) {
					dir = 0;	
				} else {
					dir = 180;
				}
				spd = 12;
				with (other) {
					instance_destroy(self);
				}
			} else {
				state = AI.dying;
				hurt_timer = 3;
				//spill coins
				global.mobsKilled++;
				global.mobsKilledThisRound++;
					for (var i=0; i<1+(returnValue(sprite_index)/2); i++) {
						instance_create_layer(x, y-16, layer, Coin);
					}
			}
		break;
		case spr_rain:
			hp -= 55;
			ds_list_add(hurt_from_list, other.id);
			if (hp > 0) {
				state = AI.hurt;
				hurt_timer = 1;
				if (other.direction >= 270) || (other.direction < 90) {
					dir = 0;	
				} else {
					dir = 180;
				}
				spd += 6;
				with (other) {
					instance_destroy(self);
				}
			} else {
				state = AI.dying;
				hurt_timer = 3;
				//spill coins
				global.mobsKilled++;
				global.mobsKilledThisRound++;
					for (var i=0; i<1+(returnValue(sprite_index)/2); i++) {
						instance_create_layer(x, y-16, layer, Coin);
					}
			}
		break;
		case spr_arcane:
			hp -= 65;
			if (hp > 0) {
				state = AI.hurt;
				hurt_timer = 0;
				if (other.pDir >= 270) || (other.pDir < 90) {
					dir = 0;	
				} else {
					dir = 180;
				}
				spd += 6;
				with (other) {
					image_speed = 1;
				}
			} else {
				state = AI.dying;
				hurt_timer = 3;
				//spill coins
				global.mobsKilled++;
				global.mobsKilledThisRound++;
					for (var i=0; i<1+(returnValue(sprite_index)/2); i++) {
						instance_create_layer(x, y-16, layer, Coin);
					}
			}
		break;
		case spr_frost:
			if (other.image_index < 5) {
				hp -= 75-(other.image_index*15);
				ds_list_add(hurt_from_list, other.id);
				if (hp > 0) {
					state = AI.hurt;
					hurt_timer = 2 - other.image_index/2;
					if (other.direction >= 270) || (other.direction < 90) {
						dir = 0;	
					} else {
						dir = 180;
					}
					spd += 12 - (other.image_index*2);
					with (other) {
						image_speed = 1;
					}
				} else {
					state = AI.dying;
					hurt_timer = 3;
					//spill coins
				global.mobsKilled++;
				global.mobsKilledThisRound++;
					for (var i=0; i<1+(returnValue(sprite_index)/2); i++) {
						instance_create_layer(x, y-16, layer, Coin);
					}
				}
			}
		break;
		case spr_dart:
			if (other.image_index < 6) {
				hp -= 100;
				ds_list_add(hurt_from_list, other.id);
				if (hp > 0) {
					state = AI.hurt;
					hurt_timer = 1;
					if (other.direction >= 270) || (other.direction < 90) {
						dir = 0;	
					} else {
						dir = 180;
					}
					spd += 12 - (other.image_index*2);
					with (other) {
						active = false;
						image_speed = 1;
					}
				} else {
					state = AI.dying;
					hurt_timer = 3;
					//spill coins
				global.mobsKilled++;
				global.mobsKilledThisRound++;
					for (var i=0; i<1+(returnValue(sprite_index)/2); i++) {
						instance_create_layer(x, y-16, layer, Coin);
					}
				}
			}
		break;
	}
}