/// @description Insert description here
// You can write your code in this editor

switch (sprite_index) {
	//ground type
	case spr_skeleton:
		image_speed = spd;
		if (dir > 0) {image_xscale = -1;} else {image_xscale = 1;}
		image_blend = c_white;
		switch (state) {
			default:
				spd = 0;
			break;
			case AI.walk:
			break;
			case AI.wary:
			break;
			case AI.attack:
			break;
			case AI.run:
			break;
			case AI.hurt:
				spd = lerp(spd, 0, 0.2);
				image_blend = (merge_color(c_white, c_red, 0.6));
			break;
			case AI.dying:
				spd = 0;
				image_blend = (merge_color(c_white, c_dkgray, 1 - (0.15*hurt_timer)));
			break;
		}
	break;
	case spr_slime:
		image_yscale = 1;
		image_xscale = 1;
		image_blend = c_white;
		switch (state) {
			default:
				spd = lerp(spd, 0, 0.1);
				image_index = 0;
			break;
			case AI.walk:
				spd = lerp(spd, 2, 0.2);
				image_speed = 1;
			break;
			case AI.wary:
				spd = lerp(spd, 2, 0.2);
				image_speed = 1;
			break;
			case AI.attack:
				spd = lerp(spd, 2, 0.3);
				image_speed = 1;
			break;
			case AI.run:
				image_speed = 1;
			break;
			case AI.hurt:
				spd = lerp(spd, 0, 0.1);
				image_blend = (merge_color(c_white, c_red, 0.6));
				image_index = 0;
			break;
			case AI.dying:
				spd = 0;
				image_blend = (merge_color(c_white, c_dkgray, 1 - (0.15*hurt_timer)));
			break;
		}
	break;
	case spr_hand:
		image_yscale = 1;
		image_xscale = 1;
		image_blend = c_white;
		switch (state) {
			case AI.idle:
				image_index = 0;
			break;
			case AI.attack:
				image_speed = 1;
			break;
			case AI.hurt:
				spd = 0;
				image_blend = (merge_color(c_white, c_red, 0.6));
			break;
			case AI.dying:
				spd = 0;
				image_blend = (merge_color(c_white, c_dkgray, 1 - (0.15*hurt_timer)));
			break;
		}
	break;
	//flying type
	case spr_eye:
		image_speed = 0.5+(spd/2);
		image_angle = dir;
		image_blend = c_white;
		switch (state) {
			default:
				spd = lerp(spd, 0, 0.05);
				image_speed = 0.1;
			break;
			case AI.walk:
			break;
			case AI.wary:
				dir = point_direction(x, y, Player.xprevious, Player.yprevious);
			break;
			case AI.attack:
				dir = point_direction(x, y, Player.x, Player.y-16);
			break;
			case AI.run:
			break;
			case AI.hurt:
				spd = lerp(spd, 0, 0.05);
				image_blend = (merge_color(c_white, c_red, 0.6));
			break;
			case AI.dying:
				spd = lerp(spd, 0, 0.08);
				image_blend = (merge_color(c_white, c_dkgray, 1 - (0.15*hurt_timer)));
			break;
		}
	break;
	case spr_jacko:
		image_speed = 0.6+(spd/2);
		image_blend = c_white;
		if ((dir < 90) || (dir > 270)) {image_xscale = 1;} else {image_xscale = -1;}
		switch (state) {
			default:
				spd = lerp(spd, 0, 0.05);
				image_speed = 0.1;
			break;
			case AI.walk:
			break;
			case AI.wary:
				dir = point_direction(x, y, Player.xprevious, Player.yprevious);
			break;
			case AI.attack:
				dir = point_direction(x, y, Player.x, Player.y-16);
			break;
			case AI.run:
			break;
			case AI.hurt:
				spd = lerp(spd, 0, 0.05);
				image_blend = (merge_color(c_white, c_red, 0.6));
			break;
			case AI.dying:
				spd = lerp(spd, 0, 0.08);
				image_blend = (merge_color(c_white, c_dkgray, 1 - (0.15*hurt_timer)));
			break;
		}
	break;
	case spr_ghost:
		image_speed = 0.3+(spd/2);
		image_blend = c_white;
		if ((dir < 90) || (dir > 270)) {image_xscale = 1;} else {image_xscale = -1;}
		switch (state) {
			default:
				spd = lerp(spd, 0, 0.05);
				image_speed = 0.1;
			break;
			case AI.walk:
			break;
			case AI.wary:
				dir = point_direction(x, y, Player.xprevious, Player.yprevious);
			break;
			case AI.attack:
				dir = point_direction(x, y, Player.x, Player.y-16);
			break;
			case AI.run:
			break;
			case AI.hurt:
				spd = lerp(spd, 0, 0.05);
				image_blend = (merge_color(c_white, c_red, 0.6));
			break;
			case AI.dying:
				spd = lerp(spd, 0, 0.08);
				image_blend = (merge_color(c_white, c_dkgray, 1 - (0.15*hurt_timer)));
			break;
		}
	break;
	case spr_bat:
		image_speed = 0.5+(spd/2);
		image_blend = c_white;
		switch (state) {
			default:
				spd = lerp(spd, 0, 0.05);
				image_speed = 0.1;
			break;
			case AI.walk:
			break;
			case AI.wary:
				dir = point_direction(x, y, Player.xprevious, Player.yprevious);
			break;
			case AI.attack:
				dir = point_direction(x, y, Player.x, Player.y-16);
			break;
			case AI.run:
			break;
			case AI.hurt:
				spd = lerp(spd, 0, 0.05);
				image_blend = (merge_color(c_white, c_red, 0.6));
			break;
			case AI.dying:
				spd = lerp(spd, 0, 0.08);
				image_blend = (merge_color(c_white, c_dkgray, 1 - (0.15*hurt_timer)));
			break;
		}
	break;
}

if (hp <= 0) {state = AI.dying;}

x += lengthdir_x(spd, dir);
y += lengthdir_y(spd, dir);