/// @description Insert description here
// You can write your code in this editor

if (global.HP > 0) && (casting) && (sprite_index == spr_witchCast) {
	casting = false;
	sprite_index = spr_witch;
		
	//create projectile
	switch (spell[0]) {
		default: 
			pDir = 0;
			if (!sign(image_xscale)){
				pDir = 180;
			}
			var p = instance_create_layer(x+(sign(image_xscale)*20), y-16, layer, Spell);
			with (p) {
				sprite_index = spr_bolt;
				pSpd = 4+random(2);
				pDir = other.pDir;
				alarm[0] = 30;
			}
		break;
		case Cast.wave:
			pDir = 0;
			if (!sign(image_xscale)){
				pDir = 180;
			}
			var p = instance_create_layer(x+(sign(image_xscale)*20), y-16, layer, Spell);
			with (p) {
				sprite_index = spr_wave;
				pSpd = (abs(other.spd)/5) + (1.1+random(0.2));
				pDir = other.pDir;
				alarm[0] = 155;
			}
		break;
		case Cast.fire:
			pDir = 55;
			if (!sign(image_xscale)){
				pDir = 125;
			}
			pDir += choose(-1,1)*random(15);
			var p = instance_create_layer(x+(sign(image_xscale)*20), y-16, layer, Spell);
			with (p) {
				sprite_index = spr_lob;
				speed = (3.5+random(1.5));
				direction = other.pDir;
				alarm[0] = 75;
				image_speed = 0.5;
			}
		break;
		case Cast.rain:
			pDir = 75;
			if (!sign(image_xscale)){
				pDir = 105;
			}
			for (var i=0; i<3; i++) {
				pDir += choose(-1,1)*random(15);
				var p = instance_create_layer(x+(sign(image_xscale)*20), y-16, layer, Spell);
				with (p) {
					sprite_index = spr_rain;
					speed = (6.5+random(1.5));
					direction = other.pDir;
					alarm[0] = 75;
				}
			}
		break;
		case Cast.arcane:
			pDir = 0;
			var sgn = sign(image_xscale);
			if (!sgn){
				pDir = 180;
			}
			for (var i=0; i<8; i++) {
				var p = instance_create_layer(x+(sgn*26)+(sgn*(i*16)), y-16, layer, Spell);
				with (p) {
					sprite_index = spr_arcane;
					pSpd = 8;
					pDir = other.pDir;
					alarm[0] = 5+(i*3);
				}
			}
		break;
		case Cast.frost:
			pDir = clamp(point_direction( x, y,mouse_x, mouse_y), 15, 65);
			var sgn = sign(image_xscale);
			if (!sgn){
				pDir = clamp(point_direction( x, y,mouse_x, mouse_y), 125, 165);
			}
			for (var i=0; i<3; i++) {
				pDir += choose(-1,1)*(random(5));
				var p = instance_create_layer(x+(sgn*26)+(sgn*(i*16)), y-28 + (4*i), layer, Spell);
				with (p) {
					sprite_index = spr_frost;
					speed = 0.5;
					direction = other.pDir;
					alarm[0] = 25+(i*15);
					active = false;
					image_alpha = 0.1;
				}
			}
		break;
		case Cast.dart:			
			pDir = clamp(point_direction(x, y,mouse_x, mouse_y), 0, 80);
			var sgn = sign(image_xscale);
			if (!sgn){
				pDir = clamp(point_direction(x, y,mouse_x, mouse_y), 180, 100);
			}
			pDir += choose(-1,1)*(random(5));
			var p = instance_create_layer(x+(sgn*26), y-16, layer, Spell);
			with (p) {
				sprite_index = spr_dart;
				speed = 2;
				direction = other.pDir;
				alarm[0] = 45;
				active = false;
				image_alpha = 0.1;
			}
		break;
	}
}