draw_set_font(fnt_font);
draw_set_halign(fa_left);
draw_set_valign(fa_top);
draw_set_color(c_white);

//Inspected
if (inspected_card != noone &&
	instance_exists(inspected_card) &&
	inspector_hover_time > 20 &&
	!inspected_card.flipped &&
	!mouse_check_button(mb_left)) {
	var _percent = min(1.0, ((inspector_hover_time - 20) / 30));
	draw_set_color(c_white);
	draw_set_alpha(_percent * 0.10);
	draw_rectangle(0, 0, room_width, room_height, false);
	
	//Card attributes
	var _width = 512 + 256;
	var _height = 224 + 64;
	var _x = (room_width div 2) - (_width div 2);
	var _y = (room_height div 2) - (_height div 2);
	draw_set_color(c_black);
	draw_set_alpha(_percent * 0.85);
	draw_rectangle(_x, _y, _x + _width, _y + _height, false);
	draw_set_alpha(_percent * 1.0);
	draw_set_color(c_white);
	draw_set_font(fnt_large);
	var _unit = inspected_card.unit;
	draw_sprite_ext(spr_units, _unit[@ UNIT.art], _x + (_width * 0.5) - 128, _y + 16, 2, 2, 0, c_white, _percent * 1.0);
	draw_text_ext(_x + 32, _y + 176, _unit[@ UNIT.text], 24, _width - 64);
	draw_set_alpha(1.0);
}

//Phase & prompt
if (turn_player == 0) {
	var _name = "";
	var _prompt = "";
	var _next = false;
	switch (phases[@ 0]) {
		case PHASE.draw:
			_name = "DRAW PHASE";
			_prompt = "Draw as many cards as you'd like by clicking on the deck! Just don't run out of cards!";
			_next = true;
			break;
		case PHASE.main:
			_name = "MAIN PHASE";
			_prompt = "Call cards to the field by dragging them from your hand!";
			_next = true;
			break;
		case PHASE.attack:
			_name = "ATTACK PHASE";
			_prompt = "Attack your opponent and their cards by clicking on your cards!";
			_next = true;
			break;
		default: break;
	}
	if (_name != "" || _prompt != "") {
		draw_set_alpha(0.75);
		draw_set_color(c_black);
		draw_rectangle(0, 0, room_width, 112, false);
		draw_set_alpha(1.0);
		draw_set_font(fnt_large);
		draw_set_color(c_white);
		draw_set_halign(fa_left);
		draw_set_valign(fa_top);
		draw_text(32, 32, _name);
		draw_set_font(fnt_font);
		draw_text(32, 64, _prompt);
	}
	if (_next) {
		var _hover = point_in_rectangle(device_mouse_x_to_gui(0), device_mouse_y_to_gui(0), room_width - 32 - 128, 32, room_width - 32, 80);
		draw_set_color(_hover ? c_lime : c_green);
		draw_rectangle(room_width - 32 - 128, 32, room_width - 32, 80, false);
		draw_set_font(fnt_large);
		draw_set_color(c_black);
		draw_set_halign(fa_center);
		draw_set_valign(fa_center);
		draw_text(room_width - 32 - 64, 58, "DONE!");
	}
}

//Winning
if (winner == players[@ 0]) {
	draw_set_font(fnt_large);
	draw_set_color(c_black);
	draw_rectangle(0, room_height div 2 - 128, room_width, room_height div 2 + 128, false);
	draw_set_color(c_lime);
	draw_set_halign(fa_center);
	draw_set_valign(fa_center);
	draw_text(room_width div 2, room_height div 2, "YOU WIN!!");
} else if (winner == players[@ 1]) {
	draw_set_font(fnt_large);
	draw_set_color(c_black);
	draw_rectangle(0, room_height div 2 - 128, room_width, room_height div 2 + 128, false);
	draw_set_color(c_red);
	draw_set_halign(fa_center);
	draw_set_valign(fa_center);
	draw_text(room_width div 2, room_height div 2, "YOU LOSE...");
}

//Cursor
draw_sprite(spr_cursor, position_meeting(mouse_x, mouse_y, obj_card), device_mouse_x_to_gui(0), device_mouse_y_to_gui(0));
/* Copyright 2023 Springroll Games / Yosi */