function card_power_change(_card, _amount) {
	//Power inc
	if (_amount > 0) {
		skills_activate(COND.power_inc, undefined, _card);
		audio_play_sound(snd_coin, 10, false);
	} else {
		audio_play_sound(snd_laser, 10, false);
	}
	
	//Defeated condition
	if (_card.card_power + _amount <= 0) {
		skills_activate(COND.is_defeated, undefined, _card);
	}
	
	_card.card_power += _amount;
	
	with (instance_create_layer(_card.x + 13, _card.y + 13, "Layer_VFX", obj_number)) {
		text = _amount;
	}
	
	//Discard the cards if they run out of power
	if (_card.card_power <= 0) {
		var _discard = zone_find(_card.owner, DISPLAY.discard);
		zone_add_card(_discard, _card);
	}
	
	_card.redraw = true;
}
/* Copyright 2023 Springroll Games / Yosi */