if (!surface_exists(surf)) {
	surf = surface_create(128, 192);
	redraw = true;
}

if (redraw) {
	redraw = false;
	surface_set_target(surf);
	draw_clear_alpha(c_white, 0.0);
	if (!flipped) {
		var _pad = 8;
		draw_sprite_ext(spr_card, 0, 0, 0, 1, 1, 0, c_white, 1.0);
		draw_set_font(fnt_charge);
		draw_set_color(c_white);
		draw_set_halign(fa_center);
		draw_set_valign(fa_center);
		draw_text(128 - _pad - 4, 0 + _pad + 5, (skill_charges == infinity) ? "-" : string(skill_charges));
		draw_set_halign(fa_left);
		draw_text(0 + _pad, 0 + _pad + 5, card_power);
		draw_sprite(spr_units, unit[@ UNIT.art], 0, 28);
		draw_set_valign(fa_top);
		draw_set_font(fnt_font);
		var _short_text = string_copy(unit[@ UNIT.text], 0, string_pos(",", unit[@ UNIT.text]) - 1) + "...";
		draw_text_ext(0 + _pad, 98, _short_text, 16, 112);
		draw_text_ext(0 + _pad, 192 - 28, unit[@ UNIT.name], 16, 112);
	} else {
		draw_sprite(spr_card_flipped, 0, 0, 0);
	}
	surface_reset_target();
}

if (!already_attacked && goal_zone.selectable && point_in_rectangle(mouse_x, mouse_y, bbox_left, bbox_top, bbox_right, bbox_bottom)) {
	draw_set_color(c_yellow);
	draw_rectangle(bbox_left - 2, bbox_top - 2, bbox_right + 2, bbox_bottom + 2, false);
}
draw_surface_ext(surf, x, y, 1, 1, image_angle, (already_attacked || goal_zone.display_type == DISPLAY.discard ? c_gray : c_white), 1.0);
/* Copyright 2023 Springroll Games / Yosi */