function skills_activate(_cond, _other_card, _single_card = undefined) {
	//Single
	if (_single_card != undefined) {
		with (_single_card) {
			if (unit[@ UNIT.condition] == _cond &&
				goal_zone.display_type == DISPLAY.field &&
				skill_charges > 0) {
				skill_charges -= 1;
				array_push(obj_game.skill_queue, {
					card : id,
					other_card : _other_card,
				});
			}
			return;
		}
	}
	
	//Universal conditions
	with (obj_card) {
		if (unit[@ UNIT.condition] == _cond &&
			goal_zone.display_type == DISPLAY.field &&
			skill_charges > 0) {
			
			//Extra checks
			if (_cond == COND.player_damaged) {
				if (_other_card != owner) then continue;
			} else if (_cond == COND.draw_card) {
				if (_other_card == owner) then continue;
			} else {
				if (obj_game.players[@ obj_game.turn_player] == owner) then continue;
			}
			
			skill_charges -= 1;
			array_push(obj_game.skill_queue, {
				card : id,
				other_card : _other_card,
			});
		}
	}
	return;
}
/* Copyright 2023 Springroll Games / Yosi */