//Drag start
if (mouse_check_button_pressed(mb_left)) {
	if (obj_game.phases[@ 0] == PHASE.main) {
		if (obj_game.dragged_id == noone || obj_game.dragged_id.depth >= depth) {
			if (goal_zone == noone || goal_zone.selectable) {
				if (point_in_rectangle(mouse_x, mouse_y, bbox_left, bbox_top, bbox_right, bbox_bottom)) {
					with (obj_card) {
						dragged = false;
					}
					dragged = true;
					obj_game.dragged_id = id;
					drag_start_x = x;
					drag_start_y = y;
					drag_mouse_x = mouse_x;
					drag_mouse_y = mouse_y;
					audio_play_sound(snd_blip, 10, false);
				}
			}
		}
	}
} else if (dragged && mouse_check_button(mb_left)) {
	//Dragging (starts on the second frame)
	x = drag_start_x + (mouse_x - drag_mouse_x);
	y = drag_start_y + (mouse_y - drag_mouse_y);
	depth = -1000;
} else {
	//Drop
	if (dragged) {
		var _zone = instance_position(mouse_x, mouse_y, obj_zone);
		if (_zone != noone && _zone.owner == owner && _zone.droppable) {
			zone_add_card(_zone, id);
		}
		obj_game.dragged_id = noone;
	}
	dragged = false;
}

//Zones
if (goal_zone != noone) {
	if (!dragged) {
		var _index = array_find(goal_zone.cards, id);
		
		//Flipped / Goal positions
		var _goal_x = x;
		var _goal_y = y;
		var _total = array_length(goal_zone.cards);
		flipped = false;
		
		if (goal_zone.display_type == DISPLAY.deck) {
			flipped = true;
			_goal_x = goal_zone.x;
			_goal_y = goal_zone.y - _index * 3;
			image_angle = 0;
		} else if (goal_zone.display_type == DISPLAY.discard) {
			flipped = false;
			_goal_x = goal_zone.x + (sin(_index * 3) * 10);
			_goal_y = goal_zone.y + (_index * -1) + (cos(_index * 2) * 10);
			image_angle = sin(_index * 2) * 4;
		} else if (goal_zone.display_type == DISPLAY.field) {
			flipped = false;
			var _mid = goal_zone.x + (goal_zone.sprite_width / 2);
			var _num = _total;
			var _pad = 16;
			var _total_width = ((_num * 128) + ((_num - 1) * _pad));
			var _half = _total_width / 2;
			_goal_x = _mid - _half + (_index * (128 + _pad));
			_goal_y = goal_zone.y;
			image_angle = 0;
		} else if (goal_zone.display_type == DISPLAY.hand) {
			if (goal_zone.owner == obj_game.players[@ 0]) {
				flipped = false;
			} else {
				flipped = true;
			}
			var _mid = goal_zone.x + (goal_zone.sprite_width / 2);
			var _num = _total;
			var _pad = 2;
			var _total_width = (10 * 128) + (9 * _pad) - 64;
			var _amount = _total_width / (_total + 1);
			var _half = _total_width / 2;
			_goal_x = _mid - _half + (_amount * (_index + 1)) - 64;
			_goal_y = goal_zone.y;
			image_angle = 0;
		}
		depth = layer_get_depth(layer_get_id("Layer_Cards")) - _index;
		
		//Move
		x = lerp(x, _goal_x, 0.25);
		y = lerp(y, _goal_y, 0.25);
	}
}
/* Copyright 2023 Springroll Games / Yosi */