#macro cam view_camera[0]

cam_shake = 0;
camera_set_view_pos(cam, 0, 128);

//Dragging cards
dragged_id = noone;

//Attacking
attacking_id = noone;
target_id = noone;

//Camera dragging
cam_drag_start_x = 0;
cam_drag_start_y = 0;
cam_mouse_start_x = 0;
cam_mouse_start_y = 0;

//Players
players = [inst_22F6EF27, inst_2875C6AC];
turn_player = 0;
players[@ 0].person = 0;
players[@ 1].hearts_max = min(30, 20 + global.fight * 2);
players[@ 1].hearts = players[@ 1].hearts_max;
winner = -1;

//CPU deck
global.other_deck = [];
repeat (30) {
	array_push(global.other_deck, irandom(clamp(round(global.fight * 5), 5, 16)));
}

//Creating random decks
with (obj_zone) {
	if (display_type == DISPLAY.deck) {
		var _deck = global.my_deck;
		if (owner == obj_game.players[@ 1]) {
			_deck = global.other_deck;
		}
		for (var i = 0; i < 30; i++) {
			var _card = instance_create_layer(x, y, "Layer_Cards", obj_card);
			_card.unit = global.units[@ _deck[@ i]];
			_card.card_power = _card.unit[@ UNIT.pow];
			_card.skill_charges = _card.unit[@ UNIT.charges];
			zone_add_card(id, _card);
		}
	}
}

//Skills
skill_queue = [];
skill_frame = 0;

//Both players draw all cards
phases = [
	PHASE.draw_beginning,
	PHASE.turn_end,
	PHASE.draw_beginning,
	PHASE.turn_end,
	PHASE.turn_start,
];
phase_frame = 0;

//Card inspector
inspected_card = noone;
inspector_hover_time = 0;
last_clicked = noone;

enum PHASE {
	turn_start,
	draw,
	draw_beginning,
	main,
	turn_end,
	attack,
	winner,
}

enum CPU {
	normal,
}

cpu_type = CPU.normal;
/* Copyright 2023 Springroll Games / Yosi */