//Winner
if (winner != -1) {
	phase_frame++;
	if (phase_frame > 300) {
		global.fight++;
		if (global.fight > 4 || winner == players[@ 1]) {
			room_goto(rm_ending);
			exit;
		}
		room_goto(rm_deck_builder);
		exit;
	}
	exit;
}

//Phase handler
var _phase = phases[@ 0];

//Skills
if (array_length(skill_queue) > 0) {
	cam_drag_start_x = camera_get_view_x(cam);
	cam_drag_start_y = camera_get_view_y(cam);
	cam_mouse_start_x = device_mouse_x_to_gui(0);
	cam_mouse_start_y = device_mouse_y_to_gui(0);
		
	//Center the camera on the skill
	var _skill = skill_queue[@ 0];
	var _card = _skill.card;
	var _pos_x = lerp(camera_get_view_x(cam), _card.x + 64 - (camera_get_view_width(cam) div 2), 0.1);
	var _pos_y = lerp(camera_get_view_y(cam), _card.y + 0 - (camera_get_view_height(cam) div 2), 0.1);
	camera_set_view_pos(
		cam,
		_pos_x + sin(current_time) * cam_shake,
		_pos_y + sin(current_time) * cam_shake,
	);
	
	//Text
	if (skill_frame == 0) {
		with (instance_create_layer(_card.x + 64, _card.y, "Layer_VFX", obj_skill_activated)) {
			owner = _card;
		}
	}
	
	//Skill stuff
	skill_frame++;
	if (skill_frame == 30) {
		_card.redraw = true;
		switch (_card.unit[@ UNIT.art]) {
			case 0:
				card_power_change(_card, 1);
				break;
			case 1:
				card_power_change(_skill.other_card, -1);
				break;
			case 2:
				player_hearts_change(obj_game.players[@ obj_game.turn_player], -1);
				break;
			case 3:
				draw_cards(_card.owner, 1);
				break;
			case 4:
				with (obj_card) {
					if (owner == _card.owner &&
						goal_zone.display_type == DISPLAY.field) {
						card_power_change(id, 1);
					}
				}
				break;
			case 5:
				card_power_change(_skill.other_card, -10);
				break;
			case 6:
				player_hearts_change(obj_game.players[@ (_card.owner == obj_game.players[@ 0] ? 1 : 0)], -1);
				break;
			case 7:
				var _targets = [];
				with (obj_card) {
					if (owner == obj_game.players[@ (_card.owner == obj_game.players[@ 0] ? 1 : 0)] &&
						goal_zone.display_type == DISPLAY.field) {
						array_push(_targets, id);
					}
				}
				if (array_length(_targets) > 0) {
					card_power_change(_targets[@ irandom(array_length(_targets) - 1)], -1);
				}
				break;
			case 8:
				card_power_change(_card, 3);
				break;
			case 9:
				with (obj_card) {
					if (owner == obj_game.players[@ (_card.owner == obj_game.players[@ 0] ? 1 : 0)] &&
						goal_zone.display_type == DISPLAY.field) {
						card_power_change(id, -1);
					}
				}
				break;
			case 10:
				draw_cards(_card.owner, 1);
				break;
			case 11:
				var _targets = [];
				with (obj_card) {
					if (owner == _card.owner &&
						goal_zone.display_type == DISPLAY.field) {
						array_push(_targets, id);
					}
				}
				if (array_length(_targets) > 0) {
					card_power_change(_targets[@ irandom(array_length(_targets) - 1)], 1);
				}
				break;
			case 12:
				var _targets = [];
				with (obj_card) {
					if (owner == obj_game.players[@ (_card.owner == obj_game.players[@ 0] ? 1 : 0)] &&
						goal_zone.display_type == DISPLAY.field) {
						array_push(_targets, id);
					}
				}
				if (array_length(_targets) > 0) {
					card_power_change(_targets[@ irandom(array_length(_targets) - 1)], -1);
				}
				break;
			case 13:
				draw_cards(_card.owner, 1);
				break;
			case 14:
				card_power_change(_card, 1);
				break;
			case 15:
				player_hearts_change(obj_game.players[@ (_card.owner == obj_game.players[@ 0] ? 1 : 0)], -1);
				break;
			case 16:
				player_hearts_change(_card.owner, 1);
				break;
			default: show_message("Oops, invalid skill!"); break;
		}
		
		//Activate other skills
		var _index = array_find(_card.goal_zone.cards, _card);
		if (array_length(_card.goal_zone.cards) > _index + 1) {
			skills_activate(COND.left_activates_ability, _card, _card.goal_zone.cards[@ _index + 1]);
		}
	}
	if (skill_frame >= 90) {
		array_delete(skill_queue, 0, 1);
		skill_frame = 0;
	}
	
	//Fade the inspector
	inspector_hover_time = max(0, inspector_hover_time - 3);
} else {
	switch (_phase) {
		case PHASE.turn_start:
			if (phase_frame == 0) {
				//Add in all the phases for the turn
				array_push(phases, PHASE.draw);
				array_push(phases, PHASE.main);
				array_push(phases, PHASE.attack);
				array_push(phases, PHASE.turn_end);
				array_push(phases, PHASE.turn_start);
				//Reset attacks
				with (obj_card) {
					if (owner == other.players[@ other.turn_player]) {
						already_attacked = false;
						skill_charges = unit[@ UNIT.charges];
						redraw = true;
					}
				}
			}
			phase_frame++;
			if (phase_frame > 60) {
				array_delete(phases, 0, 1);
				phase_frame = 0;
				break;
			}
			break;
		case PHASE.turn_end:
			if (phase_frame == 0) {
				skills_activate(COND.turn_end, undefined);
			}
			
			if (++phase_frame > 1) {
				//Next player
				turn_player++;
				if (turn_player >= array_length(players)) {
					turn_player = 0;
				}
				array_delete(phases, 0, 1);
				phase_frame = 0;
			}
			break;
		case PHASE.draw_beginning:
			camera_set_view_pos(cam, 0, 128);
			if (phase_frame % 4 == 0) {
				//The turn player draws a card
				var _player = players[@ turn_player];
				var _deck = zone_find(_player, DISPLAY.deck);
				var _hand = zone_find(_player, DISPLAY.hand);
				if (_deck != noone && _hand != noone) {
					if (array_length(_deck.cards) > 0) {
						zone_add_card(_hand, array_pop(_deck.cards));
					} else {
						win_conditions();
					}
				}
			}
			phase_frame++;
			if (phase_frame >= 24) {
				array_delete(phases, 0, 1);
				phase_frame = 0;
				break;
			}
			break;
		case PHASE.draw:
			if (turn_player == 0) {
				//Player
				//Auto draw
				if (phase_frame == 0) {
					phase_frame++;
					var _player = players[@ turn_player];
					draw_cards(_player, 1);
				}
				//Manual draws
				if (mouse_check_button_pressed(mb_left)) {
					var _player = players[@ turn_player];
					var _deck = zone_find(_player, DISPLAY.deck);
					var _hand = zone_find(_player, DISPLAY.hand);
					if (_deck != noone && _hand != noone) {
						if (position_meeting(mouse_x, mouse_y, _deck)) {
							draw_cards(_player, 1);
						}
					}
				}
			
				//Next phase
				var _hover = point_in_rectangle(device_mouse_x_to_gui(0), device_mouse_y_to_gui(0), room_width - 32 - 128, 32, room_width - 32, 80);
				if (_hover && mouse_check_button_pressed(mb_left)) {
					array_delete(phases, 0, 1);
					phase_frame = 0;
					break;
				}
			} else {
				//CPU
				if (cpu_type == CPU.normal) {
					//Auto draw
					if (phase_frame == 0) {
						phase_frame++;
						var _player = players[@ turn_player];
						draw_cards(_player, 1);
					} else {
						//Get up to 4 cards in the hand every time
						var _player = players[@ turn_player];
						var _hand = zone_find(_player, DISPLAY.hand);
						if (array_length(_hand.cards) < 4) {
							draw_cards(_player, 1);
						} else {
							array_delete(phases, 0, 1);
							phase_frame = 0;
							break;
						}
					}
				}
				if (++phase_frame > 15) {
					array_delete(phases, 0, 1);
					phase_frame = 0;
					break;
				}
			}
			break;
		case PHASE.main:
			if (turn_player == 0) {
				//Player
			
				//Next phase
				var _hover = point_in_rectangle(device_mouse_x_to_gui(0), device_mouse_y_to_gui(0), room_width - 32 - 128, 32, room_width - 32, 80);
				if (_hover && mouse_check_button_pressed(mb_left)) {
					array_delete(phases, 0, 1);
					phase_frame = 0;
					break;
				}
			} else {
				//CPU
				if (cpu_type == CPU.normal) {
					if (phase_frame == 0 || phase_frame == 4 || phase_frame == 8 || phase_frame == 12 || phase_frame == 16 || phase_frame == 20 || phase_frame == 24 || phase_frame == 28) {
						//Call 7 cards if you can
						var _hand = zone_find(players[@ turn_player], DISPLAY.hand);
						var _field = zone_find(players[@ turn_player], DISPLAY.field);
						if (_hand != noone && _field != noone && array_length(_hand.cards) > 0) {
							zone_add_card(_field, _hand.cards[@ 0]);
						}
					}
				}
				if (++phase_frame > 30) {
					array_delete(phases, 0, 1);
					phase_frame = 0;
					break;
				}
			}
			break;
		case PHASE.attack:
			if (turn_player == 0) {
				//Player
			
				//Selecting cards to attack with
				if (mouse_check_button_pressed(mb_left)) {
					var _selected = instance_position(mouse_x, mouse_y, obj_card);
					if (_selected != noone) {
						if (_selected.owner == players[@ 0] && !_selected.already_attacked && _selected.goal_zone.display_type == DISPLAY.field) {
							attacking_id = _selected;
						} else if (attacking_id != noone && _selected.owner != players[@ 0] && _selected.goal_zone.display_type == DISPLAY.field) {
							target_id = _selected;
						
							//Carry out the attack
							card_power_change(target_id, -attacking_id.card_power);
							card_power_change(attacking_id, -1);
							attacking_id.already_attacked = true;
							cam_shake = 8;
							
							skills_activate(COND.is_attacked, attacking_id, target_id);
							skills_activate(COND.attacks, attacking_id);
						
							attacking_id = noone;
							target_id = noone;
							break;
						} else {
							attacking_id = noone;
							target_id = noone;
						}
					} else {
						//Attacking opponent directly
						var _person = instance_position(mouse_x, mouse_y, obj_player);
						if (_person != noone && attacking_id != noone) {
							target_id = _person;
						
							//Carry out the attack
							player_hearts_change(_person, -1);
							card_power_change(attacking_id, -1);
							attacking_id.already_attacked = true;
							cam_shake = 10;
							
							skills_activate(COND.attacks, attacking_id);
							
							attacking_id = noone;
							target_id = noone;
							break;
						} else {
							attacking_id = noone;
							target_id = noone;
						}
					}
				}
			
				//Next phase
				var _hover = point_in_rectangle(device_mouse_x_to_gui(0), device_mouse_y_to_gui(0), room_width - 32 - 128, 32, room_width - 32, 80);
				if (_hover && mouse_check_button_pressed(mb_left)) {
					array_delete(phases, 0, 1);
					phase_frame = 0;
					break;
				}
			} else {
				//CPU
				if (cpu_type == CPU.normal) {
					var _cards_left = [];
					with (obj_card) {
						if (owner == obj_game.players[@ 1] && goal_zone.display_type == DISPLAY.field && !already_attacked) {
							array_push(_cards_left, id);
						}
					}
					
					//Find a random target
					if (phase_frame == 0) {
						if (array_length(_cards_left) > 0) {
							attacking_id = _cards_left[@ 0];
							//Choose a target
							if (irandom(100) < 50) {
								target_id = obj_game.players[@ 0];
							} else {
								var _target = noone;
								var _targets = [];
								with (obj_card) {
									if (owner == obj_game.players[@ 0] && goal_zone.display_type == DISPLAY.field) {
										array_push(_targets, id);
									}
								}
								if (array_length(_targets) > 0) {
									_target = _targets[@ irandom(array_length(_targets) - 1)];
								}
								if (_target != noone) {
									target_id = _target;
								} else {
									target_id = obj_game.players[@ 0];
								}
							}
							_cards_left[@ 0].already_attacked = true;
						} else {
							//Next phase when there are no more cards to attack with
							array_delete(phases, 0, 1);
							phase_frame = 0;
							break;
						}
					}
					//Attack
					if (phase_frame == 30) {
						if (target_id.object_index == obj_player) {
							player_hearts_change(target_id, -1);
							card_power_change(attacking_id, -1);
							cam_shake = 10;
						} else {
							card_power_change(target_id, -attacking_id.card_power);
							card_power_change(attacking_id, -1);
							cam_shake = 8;
							
							skills_activate(COND.is_attacked, attacking_id, target_id);
						}
						skills_activate(COND.attacks, attacking_id);
						
						target_id = noone;
						attacking_id = noone;
					}
					if (phase_frame >= 70) {
						phase_frame = 0;
						break;
					}
					phase_frame++;
				} else {
					if (++phase_frame > 30) {
						array_delete(phases, 0, 1);
						phase_frame = 0;
						break;
					}
				}
			}
			break;
		default:
			array_delete(phases, 0, 1);
			phase_frame = 0;
			break;
	}

	//Inspector
	var _card = instance_position(mouse_x, mouse_y, obj_card);
	if (_card != noone && !mouse_check_button(mb_left) && attacking_id == noone) {
		inspector_hover_time = min(50, inspector_hover_time + 1);
		inspected_card = _card;
	} else {
		if (_card != noone && mouse_check_button_pressed(mb_left)) {
			last_clicked = _card;
		}
		inspector_hover_time = max(0, inspector_hover_time - 3);
	}

	//Dragging the view
	if (mouse_check_button_pressed(mb_left)) {
		cam_drag_start_x = camera_get_view_x(cam);
		cam_drag_start_y = camera_get_view_y(cam);
		cam_mouse_start_x = device_mouse_x_to_gui(0);
		cam_mouse_start_y = device_mouse_y_to_gui(0);
	} else if (mouse_check_button(mb_left) && dragged_id == noone) {
		camera_set_view_pos(
			cam,
			clamp(cam_drag_start_x + (cam_mouse_start_x - device_mouse_x_to_gui(0)), -512, room_width - camera_get_view_width(cam) + 512) + sin(current_time) * cam_shake,
			clamp(cam_drag_start_y + (cam_mouse_start_y - device_mouse_y_to_gui(0)), -512, room_height - camera_get_view_height(cam) + 512) + cos(current_time) * cam_shake,
		);
	} else if (cam_shake > 1) {
		camera_set_view_pos(
			cam,
			camera_get_view_x(cam) + sin(current_time) * cam_shake,
			camera_get_view_y(cam) + sin(current_time) * cam_shake,
		);
	}
}

//Camera
cam_shake *= 0.8;

/* Copyright 2023 Springroll Games / Yosi */