function zone_add_card(_zone, _card) {
	if (_zone == _card.goal_zone) then return false;
	
	//Field limit
	if (_zone.display_type == DISPLAY.field && array_length(_zone.cards) >= 7) then return false;
	
	_card.goal_zone = _zone;
	_card.owner = _zone.owner;
	_card.redraw = true;
	with (obj_zone) {
		var _existing = array_find(cards, _card);
		if (_existing != -1) {
			array_delete(cards, _existing, 1);
		}
	}
	array_push(_card.goal_zone.cards, _card);
	
	//Shuffle deck
	if (_zone.display_type == DISPLAY.deck) {
		deck_shuffle(_zone.cards);
	}
	
	//Zone displays / resets
	with (_card) {
		var _index = array_find(goal_zone.cards, id);
		
		//Flipped
		flipped = false;
		if (goal_zone.display_type == DISPLAY.deck) {
			flipped = true;
			image_angle = 0;
			card_power = unit[@ UNIT.pow];
		} else if (goal_zone.display_type == DISPLAY.discard) {
			flipped = false;
			image_angle = sin(_index * 2) * 4;
			card_power = unit[@ UNIT.pow];
		} else if (goal_zone.display_type == DISPLAY.field) {
			flipped = false;
			image_angle = 0;
		} else if (goal_zone.display_type == DISPLAY.hand) {
			if (goal_zone.owner == obj_game.players[@ 0]) {
				flipped = false;
			} else {
				flipped = true;
			}
			image_angle = 0;
			card_power = unit[@ UNIT.pow];
		}
		depth = layer_get_depth(layer_get_id("Layer_Cards")) - _index;
	}
	
	//Skills
	if (_zone.display_type == DISPLAY.field) {
		skills_activate(COND.place_card, _card);
	}
}
/* Copyright 2023 Springroll Games / Yosi */