if(game_state == STATE_INIT)
{
	//audio_sound_gain(music,1,5);
	player_id = instance_create_depth(x,y,depth,obj_player);
	camera_id = instance_create_depth(x,y,depth,obj_camera);
	game_state = STATE_OVERWORLD;
	exit;
}

var mx = global.mx;
var my = global.my;

var gx = device_mouse_x_to_gui(0);
var gy = device_mouse_y_to_gui(0);

// LOSE
if(coolant == -1)
{	
	room_goto(room_lose);
}

// FADE UP TEXT
var i = 0;
for(i=0; i<4; i++)
{
	if(line[i,2] < 1 and line[i,0] != "")
	{
		line[i,2] += 1/30;
	}
	
	if(line[i,3] > 0 and line[i,0] != "")
	{
		line[i,3] -= 20/30;
	}
}


switch(game_state)
{
	// OVERWORLDING
	case(STATE_OVERWORLD):
	{
		var inst = collision_rectangle(mx-10,my+10,mx+10,my-10,obj_node,false,false);

		if(inst != noone)
		{
			inst.hover = true;
	
			if(mouse_check_button_pressed(mb_left) and !obj_player.start)
			{
				if(player_id.node == inst and inst.active)
				{
					game_state = STATE_EXPLORE;
					inst.hover = false;
					inst.enter_text = false;
					
					if(obj_player.node.node_string != "transit hub")
					{
						encounter_start();
					}
					else
					{
						line[0,0] = "You can send goods that you find";
						line[1,0] = "Back up to your ship for safekeeping";
						line[2,0] = "And depart once you have gathered enough";
						
						line[0,1] = c_midblue;
						line[1,1] = c_midblue;
						line[2,1] = c_midblue;
						
						line[0,2] = 1;
						line[1,2] = 1;
						line[2,2] = 1;
						
						line[0,3] = 0;
						line[1,3] = 0;
						line[2,3] = 0;
					}
				}
				else
				{
					player_id.node = inst;
					coolant -= 1;
				}
			}
	
			if(player_id.node.id == inst and !obj_player.start and inst.active)
			{
				inst.enter_text = true;
			}
		}
		else
		{
			with(obj_node)
			{
				hover = false;
				enter_text = false;
			}
		} 
	}
	break;
	
	// EXPLORING
	case(STATE_EXPLORE):
	{
		// LISTEN FOR TRIGGERS
		
		switch(trigger)
		{
			case(T_ESC):
			{
				if(!enemy_alive)
				{
					game_state = STATE_OVERWORLD;
					struck = false;
					looted = false;
					progress = 0;
				}
				else
				{
					take_damage();
				}
			}
			break;
			
			case(T_DEPART):
			{
				i = instance_create_depth(x,y,depth,obj_manifest);
	
				with(i)
				{
					manifest = ds_list_write(other.ship_inv);
					treasure_list = ds_list_create();
					ds_list_read(treasure_list,manifest);
					show_debug_message(manifest);
				}
				
				room_goto(room_win);
			}
			break;
			
			case(T_SEND):
			{
				var sent = false;
				
				while(ds_list_size(player_inv) > 0)
				{
					var v = ds_list_find_value(player_inv,0);
					ds_list_add(ship_inv,v);
					ds_list_delete(player_inv,0);
					show_debug_message("SENDING "+v);
					sent = true;
				}
				
				if(sent)
				{
					instance_create_depth(obj_player.x-1,obj_player.y,depth,obj_send);					
				}
				
				game_state = STATE_OVERWORLD;
				inv_count = 0;
				
			}
			break;
			
			case(T_LOOT):
			{	
				if(encounter_type == ET_LOOT)
				{
					looted = true;
					
					if(inv_count < inv_max)
					{
						line[0,1] = c_lime;
						line[1,0] = "You receive:";
						ds_list_shuffle(item_list);
						line[2,0] = ds_list_find_value(item_list,0);
						line[2,1] = c_iorange;
					
						line[1,2] = 0;
						line[2,2] = 0;
						line[3,2] = 0;
						line[1,3] = LINE_YOFFSET;
						line[2,3] = LINE_YOFFSET;
						line[3,3] = LINE_YOFFSET;
					
						ds_list_add(player_inv,line[2,0]);
						inv_count = ds_list_size(player_inv);
					}
					else
					{
						cs();
						line[1,0] = "Your inventory is full";
					}
				}
				else
				{
					if(enemy_alive)
					{
						take_damage();
					}
					else
					{
						if(irandom(3) == 0)
						{
							looted = true; 
							line[0,1] = c_lime;
							line[1,1] = c_midblue;
							line[1,0] = "You find more coolant";
							
							if(coolant < coolant_max)
							{
								coolant += 1;
							}
							line[1,2] = 0;
							line[2,2] = 0;
							line[3,2] = 0;
							line[1,3] = LINE_YOFFSET;
							line[2,3] = LINE_YOFFSET;
							line[3,3] = LINE_YOFFSET;
						}
						else
						{						
							looted = true;
							line[0,1] = c_lime;
							line[1,1] = c_white;
							line[1,0] = "You find nothing of value";
							line[1,2] = 0;
							line[2,2] = 0;
							line[3,2] = 0;
							line[1,3] = LINE_YOFFSET;
							line[2,3] = LINE_YOFFSET;
							line[3,3] = LINE_YOFFSET;
						}
					}
				}
			}
			break;
			
			case(T_PROCEED):
			{				
				if(enemy_alive)
				{
					take_damage();
				}
				else if(encounter_type == ET_END)
				{
					game_state = STATE_OVERWORLD;
					struck = false;
					looted = false;
					progress = 0;
				}
				else
				{
					struck = false;
					looted = false;
					progress += 1;
					show_debug_message("Dungeon progress = "+string(progress));
					encounter_start();
				}
			}
			break;
			
			case(T_STRIKE):
			{
				struck = true;
				
				if(encounter_type == ET_FIGHT)
				{
					line[0,1] = c_lime;
					line[1,0] = "You destroy your assailant";
					line[1,1] = c_white;
					line[2,0] = "";
					line[3,0] = "";
					enemy_alive = false;
					
					line[1,2] = 0;
					line[2,2] = 0;
					line[3,2] = 0;
					line[1,3] = LINE_YOFFSET;
					line[2,3] = LINE_YOFFSET;
					line[3,3] = LINE_YOFFSET;
				}
				else
				{
					line[0,1] = c_lime;
					line[1,0] = "Your assault is ineffective";
					line[1,1] = c_white;
					line[2,0] = "";
					line[3,0] = "";
					
					line[1,2] = 0;
					line[2,2] = 0;
					line[3,2] = 0;
					line[1,3] = LINE_YOFFSET;
					line[2,3] = LINE_YOFFSET;
					line[3,3] = LINE_YOFFSET;
				}
			}
			break;		
		}
		
		trigger = T_NEUTRAL;
		
	}
	break;
	
	// EXPLORING
	case(STATE_INIT):
	{
		// DO NOTHING
	}
	break;
}